/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IInstanceFactoryRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.SharedDataStructure;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class SharedDataStructure2
implements IInstanceFactoryRepository {
    private volatile boolean fTouched = false;
    private final AtomicReference<ISharedElement> sharedValue = new AtomicReference();
    private ConcurrentLinkedQueue<ISharedElement> concurrentElement = new ConcurrentLinkedQueue();
    private final ISharedElement kInstancer;
    private volatile boolean fShutOff = false;

    public SharedDataStructure2(ISharedElement instance) {
        this.kInstancer = instance;
        this.reset();
    }

    @Override
    public void offer(ISharedElement offered) {
        this.fTouched = true;
        if (!this.sharedValue.compareAndSet(null, offered)) {
            this.concurrentElement.offer(offered);
        }
    }

    public String toString() {
        return Thread.currentThread().getName() + " value = " + this.sharedValue.get();
    }

    @Override
    public ISharedElement get() {
        this.fTouched = true;
        ISharedElement tryGet = this.sharedValue.getAndSet(null);
        if (tryGet != null) {
            return tryGet;
        }
        return this.kInstancer.getSharedElementInstance();
    }

    @Override
    public void reset() {
        this.fTouched = true;
        this.sharedValue.set(this.kInstancer.getSharedElementInstance());
    }

    @Override
    public ISharedElement read() {
        ISharedElement polled;
        ISharedElement tryGet = null;
        while ((tryGet = (ISharedElement)this.sharedValue.getAndSet(null)) == null) {
        }
        this.fTouched = false;
        ISharedElement result = tryGet.getSharedElementInstance();
        result.merge(tryGet);
        if (tryGet.shouldBeConsumendOnRead()) {
            tryGet.reset();
        } else {
            tryGet.resetMinMax();
        }
        this.sharedValue.set(tryGet);
        while ((polled = this.concurrentElement.poll()) != null) {
            result.merge(polled);
        }
        return result;
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        ISharedElement current = this.read();
        result.merge(current);
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SharedDataStructure(instance);
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, int hashcode) {
        ISharedElement element = this.get();
        updater.update(element, value, startTime);
        this.offer(element);
    }

    @Override
    public boolean hasNotChanged() {
        return !this.fTouched;
    }

    @Override
    public boolean shouldBeHarvested() {
        return !this.kInstancer.shouldBeConsumendOnRead() || this.fTouched;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public ISharedElement getSharedElementInstance() {
        return this.kInstancer.getSharedElementInstance();
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (offerBack) {
            this.offer(this.read());
        } else {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

