/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementCallbackOnRecursion;

public class StackRecursionHelper {
    public static volatile int kMaxRecursive = 4096;

    public static IStackElement staticSafeRecurseAccessParent(IStackElement stackElement, IStackElementCallbackOnRecursion callback) {
        return StackRecursionHelper.staticSafeRecurseAccessParent(stackElement, callback, kMaxRecursive);
    }

    public static IStackElement staticSafeRecurseAccessParent(IStackElement stackElement, IStackElementCallbackOnRecursion callback, int maxRecursion) {
        IStackElement pivot;
        int i = 0;
        for (pivot = stackElement; pivot != null; pivot = pivot.getParent()) {
            if (!callback.doOnElement(pivot)) continue;
            return pivot;
        }
        return pivot;
    }

    public static void staticSafeRecurseAccessAll(IStackElement stackElement, IStackElementCallbackOnRecursion callback, int maxRecursion) {
        int i = 0;
        for (IStackElement pivot = stackElement; pivot != null; pivot = pivot.getParent()) {
            callback.doOnElement(pivot);
            if (++i <= maxRecursion) continue;
            return;
        }
    }

    public static ITransactionElement staticSafeRecurseAccessParent(ITransactionElement txnElement, ITransactionElementCallbackOnRecursion callback, int maxRecursion) {
        ITransactionElement pivot;
        int i = 0;
        for (pivot = txnElement; pivot != null; pivot = pivot.getParent()) {
            if (!callback.doOnElement(pivot)) continue;
            return pivot;
        }
        return pivot;
    }

    public static void initializeMaxRecursionHelper(int value) {
        kMaxRecursive = value;
    }
}

