/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.probe.net.DefaultBackendFeatureFactory;
import com.wily.introscope.agent.probe.net.IDefaultBackendFeature;
import com.wily.introscope.agent.trace.BackendTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.introscope.agent.trace.io.ISocketNameFormatter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.StreamMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;

public final class SocketBackendTracer
extends BackendTracer {
    private static final IAgent sAgent = SocketBackendTracer.findAgent();
    private static boolean shouldAnnotateTT = sAgent == null ? false : sAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.reportInTT", true);
    private static final ComponentTracer sComponentTracer = sAgent == null ? null : sAgent.IAgent_getComponentTracer();
    private final String fAnnotationTitle = this.getParameter("annotationtitle");
    private static final int fMetricPosition = 9;

    private static final IAgent findAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError("Unable to gather socket data because the Agent is not available", anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public SocketBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.isRequired(data)) {
            this.annotateBlameStack(data);
        }
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    void annotateBlameStack(InvocationData data) {
        String formattedName;
        IDefaultBackendFeature feature;
        if (shouldAnnotateTT && !(feature = DefaultBackendFeatureFactory.getFeatureForCurrentThread()).backendWasTouchedInMostRecentBlameFrame() && (formattedName = this.quickFormat(data)) != null) {
            IBlameStack stack = data.getStack(sComponentTracer, false);
            sComponentTracer.addExtraParameter(stack, this.getAnnotationTitle(), formattedName);
            SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
            if (cache != null) {
                feature.setDefaultBackend(formattedName, cache.getHostName(), cache.getPort());
            } else {
                InetSocketAddress address = StreamMap.getAddress(data.getInvocationObject());
                feature.setDefaultBackend(formattedName, AddressHostNameHelper.getHostName(address), address.getPort());
            }
        }
    }

    public static void annotateBlameStack(String formattedName, String annotationTitle, SocketFormatMetricsCache cache) {
        IDefaultBackendFeature feature;
        if (cache == null) {
            Assertion.wilyAssert("Cannot annotate blame stack without a cache object");
        }
        if (shouldAnnotateTT && !(feature = DefaultBackendFeatureFactory.getFeatureForCurrentThread()).backendWasTouchedInMostRecentBlameFrame() && formattedName != null) {
            sComponentTracer.addExtraParameter(annotationTitle, formattedName);
            feature.setDefaultBackend(formattedName, cache.getHostName(), cache.getPort());
        }
    }

    @Override
    protected final String getComponentName(InvocationData data) {
        Assertion.wilyAssert("Flow Exception. The getComponentName method should not be called on the SocketBackendTracer");
        return null;
    }

    protected final boolean isRequired(InvocationData data) {
        if (data.isSocketRequired()) {
            SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
            if (cache != null) {
                return cache.isClientConnection();
            }
            Object invocationObject = data.getInvocationObject();
            if (invocationObject instanceof InputStream || invocationObject instanceof OutputStream) {
                return StreamMap.isClientConnection(invocationObject);
            }
            Assertion.wilyAssert("Instrumentation error: invocation object not an InputStream or OutputStream");
        }
        return false;
    }

    protected String getAnnotationTitle() {
        return this.fAnnotationTitle;
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    protected final String quickFormat(InvocationData data) {
        String value = this.getFormattedName();
        try {
            ISocketNameFormatter formatter = (ISocketNameFormatter)((Object)this.getCustomNameFormatter());
            value = formatter.ISocketNameFormatter_format(value, data, 9);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Formatting_Name_Error_Message", value, this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()));
            this.getModuleFeedback().verbose(t);
        }
        return value;
    }
}

