/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketMap;
import com.wily.introscope.agent.trace.io.SocketPerIntervalCounter;
import com.wily.util.properties.AttributeListing;
import java.net.Socket;

public final class SocketConnectPerIntervalCounter
extends SocketPerIntervalCounter
implements ITracer {
    public SocketConnectPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof Socket) {
            return this;
        }
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        Object invocationObject = data.getInvocationObject();
        Socket socket = (Socket)invocationObject;
        if (SocketMap.isRequired(socket, this.getAgent()) && (formattedName = this.quickFormat(data, this.getMetricPosition())) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    @Override
    protected final int getMetricPosition() {
        return 2;
    }

    @Override
    protected void increaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.addToConnectCounter();
    }
}

