/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.io.SocketConfiguration;
import com.wily.introscope.agent.trace.io.SocketMap;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;

public final class StreamMap {
    private static AtomicReference<ConcurrentWeakThreadLocalHashMap<Object, WeakReference<Socket>>> sStreamMapCache = new AtomicReference<Object>(null);

    private static final void initStreamMapCache() {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            ConcurrentWeakThreadLocalHashMap map = mapFactory.getConcurrentWeakHashMap("StreamMapCache");
            sStreamMapCache.set(map);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }

    public static final void put(Object stream, Socket object) {
        ConcurrentWeakThreadLocalHashMap<Object, WeakReference<Socket>> map = sStreamMapCache.get();
        if (map == null) {
            StreamMap.initStreamMapCache();
            map = sStreamMapCache.get();
        }
        if (map != null) {
            map.putWeak(stream, new WeakReference<Socket>(object));
        }
    }

    private static final Socket get(Object stream) {
        ConcurrentWeakThreadLocalHashMap<Object, WeakReference<Socket>> map = sStreamMapCache.get();
        if (map == null) {
            StreamMap.initStreamMapCache();
            map = sStreamMapCache.get();
        }
        if (map != null) {
            Socket socket;
            WeakReference<Socket> socketRef = map.getWeak(stream);
            Socket socket2 = socket = socketRef == null ? null : (Socket)socketRef.get();
            if (socket == null) {
                map.removeWeak(stream);
            }
            return socket;
        }
        return null;
    }

    public static final InetSocketAddress getAddress(Object stream) {
        return SocketMap.getAddress(StreamMap.get(stream));
    }

    public static final int getPort(Object stream) {
        return SocketMap.getPort(StreamMap.get(stream));
    }

    public static final String getHost(Object stream) {
        return SocketMap.getHost(StreamMap.get(stream));
    }

    public static final String getResourceName(Object stream) {
        return SocketMap.getResourceName(StreamMap.get(stream));
    }

    public static final boolean isClientConnection(Object stream) {
        return SocketMap.isClientConnection(StreamMap.get(stream));
    }

    public static final boolean isRequired(Object stream, IAgent agent) {
        SocketConfiguration cc = SocketConfiguration.getSocketConfiguration(agent);
        if (cc.isRequiredEnabled()) {
            return SocketMap.isRequired(StreamMap.get(stream), agent);
        }
        return true;
    }

    public static final ASocketNameFormatter.ResourceAndAddress getResourceAndAddressName(Object stream) {
        return SocketMap.getResourceAndAddressName(StreamMap.get(stream));
    }
}

