/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.CompoundComponentParameterCallback;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.ParameterGatheringCallback;
import com.wily.introscope.agent.blame.PreformedCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.INeutralTransactionTypeTraceFilter;
import com.wily.introscope.agent.transactiontrace.ISamplingTransactionTraceFilter;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.AFilterListTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ILegacyTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IStatefulTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TransactionRecordingBlameStack
implements IBlameStack {
    private ITransactionTraceListener fListener;
    private ITransactionTraceFilter[] fFilters;
    private StackLinkedList fComponentStack = new StackLinkedList();
    private boolean fKeepCollecting;
    private boolean fKeepChecking;
    private ITransactionTraceFilter[] fPendingFilters;
    private Object[] fPendingFailFastFilterStatus = null;
    private IFailFastTransactionTraceFilter[] fPendingFailFastTailFilters;
    private int fPendingFailFastHeadFilterCount;
    private boolean fTailFilter;
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    public String fURL;
    private int fComponentCountClamp;
    private int fHeadFilterClamp;
    private int fMagnitude;
    private int fComponentClampAfterCount;
    private int fComponentClampMarker;
    private boolean fComponentClampOcurred;
    private int fInitialPushCount;
    private boolean fHasPopped;
    private boolean fSpewedClampError;
    private ITransactionEnvironment fTransactionEnv;
    private IAgent agent;
    private boolean fFilterPassed = false;
    private boolean fHeadFilterPassed = false;
    private boolean fFailFastFilterPassed = false;
    private static int sErrorMsgCount = 0;
    private static final int kErrorMsgSoftLimit = 50;
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();
    private String fTransactionIdentity;

    public TransactionRecordingBlameStack(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, ITransactionTraceFilter[] filters, ITransactionEnvironment transactionenv) {
        this(feedback, localizer, listener, filters, 5000, 30, transactionenv);
    }

    public TransactionRecordingBlameStack(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, ITransactionTraceFilter[] filters, int componentCountClamp, int headFilterClamp, ITransactionEnvironment transactionenv) {
        this.initialize(feedback, localizer, listener, filters, componentCountClamp, headFilterClamp, transactionenv);
    }

    private void populateFailFastFilters(ITransactionTraceFilter[] filters) {
        this.fPendingFailFastHeadFilterCount = 0;
        if (this.fPendingFilters == null || this.fPendingFilters.length != filters.length) {
            this.fPendingFilters = new ITransactionTraceFilter[filters.length];
            this.fPendingFailFastFilterStatus = new Object[filters.length];
            this.fPendingFailFastTailFilters = new IFailFastTransactionTraceFilter[filters.length];
        }
        System.arraycopy(this.fFilters, 0, this.fPendingFilters, 0, this.fPendingFilters.length);
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].isHeadFilter() || !(filters[i] instanceof IFailFastTransactionTraceFilter)) continue;
            ++this.fPendingFailFastHeadFilterCount;
        }
        this.initializePendingFilterStatus();
    }

    private void initialize(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, ITransactionTraceFilter[] filters, int componentCountClamp, int headFilterClamp, ITransactionEnvironment transactionenv) {
        this.fListener = listener;
        this.fFilters = filters;
        this.populateFailFastFilters(this.fFilters);
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fComponentCountClamp = componentCountClamp;
        this.fHeadFilterClamp = headFilterClamp;
        this.fComponentClampMarker = 0;
        this.fComponentClampAfterCount = 0;
        this.initializeSimpleState();
        this.fTransactionEnv = transactionenv;
        try {
            this.agent = AgentShim.getAgent();
            SharedCrossProcessData cache = this.agent.IAgent_getComponentTracer().getCrossProcessDataCache();
            String transactionId = cache.getStringParamOut("TxnTraceId");
            if (transactionId != null) {
                this.fTransactionIdentity = transactionId;
                if (this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack re-using existing GUID " + transactionId);
                }
            } else {
                cache.addParamOut("TxnTraceId", this.fTransactionIdentity);
                if (this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack added new  GUID " + this.fTransactionIdentity);
                }
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }

    private void checkForTailFilters() {
        for (int i = 0; i < this.fFilters.length; ++i) {
            if (this.fFilters[i].isHeadFilter()) continue;
            this.fTailFilter = true;
        }
    }

    private void initializeSimpleState() {
        this.fKeepCollecting = true;
        this.fKeepChecking = true;
        this.fURL = null;
        this.fSpewedClampError = false;
        this.fMagnitude = 1;
        this.fInitialPushCount = 0;
        this.fHasPopped = false;
        this.fTailFilter = false;
        this.checkForTailFilters();
        this.fFilterPassed = false;
        this.fHeadFilterPassed = false;
        this.fFailFastFilterPassed = false;
        this.fTransactionIdentity = sGuidGenerator.generateKey();
        this.fComponentClampOcurred = false;
    }

    long getComponentCountClamp() {
        return this.fComponentCountClamp;
    }

    long getHeadCountClamp() {
        return this.fHeadFilterClamp;
    }

    @Override
    public void IBlameStack_addComponent(String component) {
        if (this.fKeepCollecting && !this.fComponentClampOcurred) {
            this.handleAdd(component, null);
        } else if (this.fComponentClampOcurred) {
            ++this.fComponentClampMarker;
            ++this.fComponentClampAfterCount;
            this.fKeepCollecting = false;
            this.fFilterPassed = this.finalPendingHeadFiltersExecute();
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        if (this.fKeepCollecting && !this.fComponentClampOcurred) {
            this.handleAdd(component, new PreformedCallback(paramName, paramValue));
        } else if (this.fComponentClampOcurred) {
            ++this.fComponentClampMarker;
            ++this.fComponentClampAfterCount;
            this.fKeepCollecting = false;
            this.fFilterPassed = this.finalPendingHeadFiltersExecute();
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        if (this.fKeepCollecting && !this.fComponentClampOcurred) {
            this.handleAdd(component, callback);
        } else if (this.fComponentClampOcurred) {
            ++this.fComponentClampMarker;
            ++this.fComponentClampAfterCount;
            this.fKeepCollecting = false;
            this.fFilterPassed = this.finalPendingHeadFiltersExecute();
        }
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        if (!this.fKeepCollecting) {
            return;
        }
        TransactionStackElement top = this.peek();
        if (top != null) {
            top.addCallbackParams(paramName, paramValue);
        }
    }

    @Override
    public void addRootParameter(String key, String value) {
        TransactionStackElement root;
        if (this.fComponentStack != null && (root = this.fComponentStack.getHead()) != null) {
            root.addCallbackParams(key, value);
        }
    }

    private void addCallbackParameters(IComponentParameterCallback callback, HashMap map) {
        try {
            if (callback != null) {
                callback.IComponentParameterCallback_addParameters(map);
                String URL2 = (String)map.get("URL");
                if (URL2 != null) {
                    this.fURL = URL2;
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.getAgent().IAgent_getModuleFeedback().verbose(AgentShim.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                AgentShim.getAgent().IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getAgentNameQualifier() {
        String[] triplet = this.agent.IAgent_getHostProcessAgentTriplet();
        StringBuilder temp = new StringBuilder();
        if (triplet.length == 3) {
            temp.append(triplet[0]);
            for (int i = 1; i < triplet.length; ++i) {
                temp.append("|");
                temp.append(triplet[i]);
            }
        }
        return temp.toString();
    }

    private boolean handleAdd(String component, IComponentParameterCallback callback) {
        boolean result = false;
        boolean headState = false;
        if (this.fComponentStack.getHead() == null) {
            headState = true;
        }
        result = this.push(new TransactionStackElement(this, component, callback));
        if (headState && result) {
            SharedCrossProcessData cache = this.agent.IAgent_getComponentTracer().getCrossProcessDataCache();
            cache.addParamOut("TxnTraceId", this.fTransactionIdentity);
        }
        if (this.fMagnitude < this.fComponentCountClamp) {
            ++this.fMagnitude;
        } else {
            this.fKeepCollecting = false;
            this.fComponentClampOcurred = true;
            int incrementedErrorCount = ++sErrorMsgCount;
            if (!this.fSpewedClampError && incrementedErrorCount < 50) {
                this.fSpewedClampError = true;
                this.fFeedback.warn("Transaction trace component limit of " + this.fComponentCountClamp + " reached, recording of any new components will cease for this transaction.");
            }
        }
        if (this.fKeepChecking) {
            this.fFilterPassed = this.collectIfPassesFilters(this.fComponentStack);
            if (this.fFilterPassed) {
                this.fKeepChecking = false;
            }
        }
        return result;
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
        this.fHasPopped = true;
        if (this.fComponentClampOcurred) {
            if (this.fComponentClampMarker > 0) {
                --this.fComponentClampMarker;
            } else if (this.fComponentClampMarker == 0) {
                this.fKeepCollecting = true;
            }
        }
        if (!this.fKeepCollecting) {
            return;
        }
        if (this.fKeepChecking && this.fPendingFailFastHeadFilterCount == 0) {
            this.fKeepChecking = false;
            if (!this.fTailFilter) {
                this.fKeepCollecting = false;
            }
        }
        Assertion.wilyAssert(false);
        if (!this.fComponentStack.isEmpty()) {
            TransactionStackElement element = this.pop();
            Assertion.wilyAssert(false);
            boolean empty = this.fComponentStack.isEmpty();
            TransactionComponentData data = element.finish(empty);
            if (data != null) {
                if (empty) {
                    if (this.fComponentClampOcurred) {
                        data.setParameterValue("Components Not Shown", Integer.toString(this.fComponentClampAfterCount));
                    }
                    this.reportIfPassesFilters(data);
                } else {
                    this.peek().addSubElement(data);
                }
            }
        }
    }

    private void reportIfPassesFilters(TransactionComponentData data) {
        boolean passedSamplingFilter = false;
        boolean passedFilter = this.fFailFastFilterPassed;
        boolean passedNeutralFilter = false;
        if (!this.fFailFastFilterPassed) {
            passedFilter = this.finalPendingHeadFiltersExecute() || this.finalPendingTailFiltersExecute(data);
        }
        for (int i = 0; i < this.fPendingFilters.length; ++i) {
            ITransactionTraceFilter filter = this.fPendingFilters[i];
            if (filter == null) continue;
            if (filter instanceof IFailFastTransactionTraceFilter) {
                boolean hasLegacyListHeadFilter;
                boolean isLegacyFilter = filter instanceof ILegacyTransactionTraceFilter;
                boolean isListFilter = filter instanceof AFilterListTransactionTraceFilter;
                boolean bl = hasLegacyListHeadFilter = isListFilter ? ((AFilterListTransactionTraceFilter)filter).hasLegacyHeadFilter() : false;
                if ((!isListFilter || !hasLegacyListHeadFilter) && !isLegacyFilter) continue;
            }
            if (!filter.ITransactionTraceFilter_passesFilter(data)) continue;
            if (filter instanceof ISamplingTransactionTraceFilter) {
                passedSamplingFilter = true;
                continue;
            }
            if (filter instanceof INeutralTransactionTypeTraceFilter) {
                passedNeutralFilter = true;
                continue;
            }
            passedFilter = true;
            break;
        }
        if (passedSamplingFilter && !passedFilter) {
            TransactionComponentData sampleData = this.replaceEventTypeWithSampled(data);
            this.fListener.ITransactionTraceListener_reportTransaction(sampleData);
        } else if (passedNeutralFilter || passedFilter) {
            this.fListener.ITransactionTraceListener_reportTransaction(data);
        }
    }

    private TransactionComponentData replaceEventTypeWithSampled(TransactionComponentData root) {
        TransactionComponentData[] children = new TransactionComponentData[root.getSubNodeCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (TransactionComponentData)root.getSubNode(i);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(root.getParameters());
        params.put("Trace Type", "Sampled");
        TransactionComponentData newRoot = new TransactionComponentData(root.getResource(), root.getStartTime(), root.getDuration(), params, children);
        return newRoot;
    }

    private boolean collectIfPassesFilters(StackLinkedList transactionStackElements) {
        Assertion.wilyAssert(false);
        TransactionStackElement element = transactionStackElements.getTail();
        HashMap parameters = new HashMap();
        if (element != null) {
            HashMap prevParameters;
            TransactionStackElement prev = element.getPrevious();
            if (prev != null && (prevParameters = prev.getParameters()) != null) {
                parameters.putAll(prevParameters);
            }
            if (parameters == null) {
                parameters = new HashMap(4);
            }
            element.setParameters(parameters);
            if (element.fCallback != null) {
                try {
                    element.fCallback.IComponentParameterCallback_addParameters(parameters);
                }
                catch (Exception e) {
                    this.fFeedback.error(this.fLocalizer.IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                    this.fFeedback.verbose(e);
                }
            }
        }
        boolean shouldCollect = false;
        boolean isMarked = false;
        SharedCrossProcessData cache = this.agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        for (int i = 0; i < this.fPendingFilters.length; ++i) {
            if (this.fPendingFilters[i] == null) continue;
            if (this.fPendingFilters[i].isHeadFilter() && this.fPendingFilters[i] instanceof IFailFastTransactionTraceFilter && this.fPendingFailFastHeadFilterCount > 0) {
                IFailFastTransactionTraceFilter filter = (IFailFastTransactionTraceFilter)this.fPendingFilters[i];
                Boolean result = this.shouldCollectHead((IFailFastTransactionTraceFilter)this.fPendingFilters[i], parameters, this.fPendingFailFastFilterStatus[i]);
                if (result == null) continue;
                this.fPendingFilters[i] = null;
                --this.fPendingFailFastHeadFilterCount;
                if (result.booleanValue()) {
                    shouldCollect = true;
                    this.fHeadFilterPassed = true;
                    this.fFailFastFilterPassed = true;
                    break;
                }
                this.fPendingFilters[i] = null;
                continue;
            }
            if (!this.fPendingFilters[i].isHeadFilter() && this.fPendingFilters[i] instanceof IFailFastTransactionTraceFilter) {
                Boolean headFilterResult;
                if (this.fPendingFilters[i] instanceof AndTransactionTraceFilter) {
                    headFilterResult = this.shouldCollectHead((IFailFastTransactionTraceFilter)this.fPendingFilters[i], parameters, this.fPendingFailFastFilterStatus[i]);
                    if (headFilterResult == null) continue;
                    if (headFilterResult.booleanValue()) {
                        this.fPendingFailFastTailFilters[i] = (IFailFastTransactionTraceFilter)this.fPendingFilters[i];
                        this.fPendingFilters[i] = null;
                        continue;
                    }
                    this.fPendingFilters[i] = null;
                    continue;
                }
                if (!(this.fPendingFilters[i] instanceof OrTransactionTraceFilter) || (headFilterResult = this.shouldCollectHead((IFailFastTransactionTraceFilter)this.fPendingFilters[i], parameters, this.fPendingFailFastFilterStatus[i])) == null) continue;
                if (headFilterResult.booleanValue()) {
                    shouldCollect = true;
                    this.fHeadFilterPassed = true;
                    this.fFailFastFilterPassed = true;
                    break;
                }
                this.fPendingFailFastTailFilters[i] = (IFailFastTransactionTraceFilter)this.fPendingFilters[i];
                this.fPendingFilters[i] = null;
                continue;
            }
            if (!this.fPendingFilters[i].isHeadFilter() || !this.fPendingFilters[i].shouldCollect(parameters)) continue;
            shouldCollect = true;
            this.fHeadFilterPassed = true;
            break;
        }
        if (shouldCollect && cache != null && !isMarked) {
            cache.setPropagationFlag(1);
            isMarked = true;
        }
        return shouldCollect;
    }

    private Boolean shouldCollectHead(IFailFastTransactionTraceFilter filter, Map parameters, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectHead(parameters, status);
        }
        return filter.shouldCollectHead(parameters);
    }

    private boolean shouldCollectFinal(IFailFastTransactionTraceFilter filter, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectFinal(status);
        }
        return filter.shouldCollectFinal();
    }

    private void initializePendingFilterStatus() {
        for (int i = 0; i < this.fPendingFilters.length; ++i) {
            ITransactionTraceFilter filter = this.fPendingFilters[i];
            if (filter == null || !(filter instanceof IStatefulTransactionTraceFilter)) continue;
            this.fPendingFailFastFilterStatus[i] = ((IStatefulTransactionTraceFilter)filter).initializeFilterState(this.fPendingFailFastFilterStatus[i]);
        }
    }

    private boolean finalPendingTailFiltersExecute(TransactionComponentData data) {
        for (int i = 0; i < this.fPendingFailFastTailFilters.length; ++i) {
            AFilterListTransactionTraceFilter filter = (AFilterListTransactionTraceFilter)this.fPendingFailFastTailFilters[i];
            if (filter == null || !filter.passesTailFilter(data)) continue;
            return true;
        }
        return false;
    }

    private boolean finalPendingHeadFiltersExecute() {
        for (int i = 0; i < this.fPendingFilters.length; ++i) {
            boolean headFilterResult;
            ITransactionTraceFilter filter = this.fPendingFilters[i];
            if (filter == null || !(filter instanceof IFailFastTransactionTraceFilter) || filter instanceof ILegacyTransactionTraceFilter || filter instanceof AFilterListTransactionTraceFilter && ((AFilterListTransactionTraceFilter)filter).hasLegacyHeadFilter()) continue;
            if (filter.isHeadFilter() && this.shouldCollectFinal((IFailFastTransactionTraceFilter)filter, this.fPendingFailFastFilterStatus[i])) {
                return true;
            }
            if (filter.isHeadFilter()) continue;
            if (filter instanceof AndTransactionTraceFilter) {
                headFilterResult = this.shouldCollectFinal((IFailFastTransactionTraceFilter)filter, this.fPendingFailFastFilterStatus[i]);
                if (!headFilterResult) continue;
                this.fPendingFailFastTailFilters[i] = (IFailFastTransactionTraceFilter)filter;
                continue;
            }
            if (!(filter instanceof OrTransactionTraceFilter)) continue;
            headFilterResult = this.shouldCollectFinal((IFailFastTransactionTraceFilter)filter, this.fPendingFailFastFilterStatus[i]);
            if (headFilterResult) {
                return true;
            }
            this.fPendingFailFastTailFilters[i] = (IFailFastTransactionTraceFilter)filter;
        }
        return false;
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        if (!this.fKeepCollecting) {
            return true;
        }
        return this.fComponentStack.isEmpty();
    }

    @Override
    public void IBlameStack_tearDown() {
        this.fComponentStack.clear();
        if (this.fPendingFilters != null && this.fPendingFilters.length != 0) {
            Arrays.fill(this.fPendingFilters, null);
        }
        if (this.fPendingFailFastTailFilters != null && this.fPendingFailFastTailFilters.length != 0) {
            Arrays.fill(this.fPendingFailFastTailFilters, null);
        }
        this.populateFailFastFilters(this.fFilters);
        this.initializeSimpleState();
    }

    @Override
    public void setEndBoundary(String component) {
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public boolean hasFrontBoundary() {
        return false;
    }

    @Override
    public boolean noteBoundaryError() {
        return false;
    }

    private TransactionStackElement peek() {
        return this.fComponentStack.getTail();
    }

    private boolean push(TransactionStackElement component) {
        boolean result = this.fComponentStack.isEmpty();
        boolean doAdd = true;
        if (this.fKeepChecking && !this.fHasPopped && !this.fTailFilter) {
            if (this.fInitialPushCount > this.fHeadFilterClamp) {
                doAdd = false;
                this.fKeepChecking = false;
                this.fKeepCollecting = false;
                this.fFeedback.warn("Transaction trace head component limit of " + this.fHeadFilterClamp + " reached, transaction will stop recording.");
            } else {
                ++this.fInitialPushCount;
            }
        }
        if (doAdd) {
            this.fComponentStack.add(component);
        }
        return result;
    }

    private TransactionStackElement pop() {
        Assertion.wilyAssert(false);
        return this.fComponentStack.removeLast();
    }

    public ITransactionTraceFilter[] debug_getFilters() {
        return this.fFilters;
    }

    public boolean debug_getKeepCollecting() {
        return this.fKeepCollecting;
    }

    public boolean debug_getKeepChecking() {
        return this.fKeepChecking;
    }

    public void debug_reportIfPassesFilters(TransactionComponentData data) {
        this.reportIfPassesFilters(data);
    }

    @Override
    public String[] getDefaultBackendData() {
        return null;
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public int getSize() {
        return this.fComponentStack.getSize();
    }

    public int getComponentCountAfterClampSet() {
        return this.fComponentClampAfterCount;
    }

    public boolean isTransactionTraceClamped() {
        return this.fComponentClampOcurred;
    }

    @Override
    public void endBoundaryPopped(String component) {
    }

    @Override
    public void frontBoundaryPopped(String component) {
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
    }

    @Override
    public void removeMapComponent(IStackType type, String component) {
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return this.fFilterPassed;
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        if (!this.fKeepChecking && !this.fKeepCollecting) {
            return false;
        }
        if (this.fHeadFilterPassed) {
            return true;
        }
        if (this.fTailFilter) {
            return this.agent.IAgent_getTransactionTraceController().isTailFilterPropagationEnabled();
        }
        return this.fFilterPassed;
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
    }

    public String toString() {
        String head = null;
        String tail = null;
        TransactionStackElement headEle = this.fComponentStack.getHead();
        TransactionStackElement tailEle = this.fComponentStack.getTail();
        if (headEle != null) {
            head = headEle.getComponent();
        }
        if (tailEle != null) {
            tail = tailEle.getComponent();
        }
        return "[TransactionRecordingBlameStack: head=" + head + ", tail=" + tail + "]";
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
    }

    private static class StackLinkedList {
        private TransactionStackElement head;
        private TransactionStackElement tail;
        private int size;

        StackLinkedList() {
            this.init();
        }

        private void init() {
            this.tail = null;
            this.head = null;
            this.size = 0;
        }

        void clear() {
            this.init();
        }

        void add(TransactionStackElement e) {
            Assertion.wilyAssert(this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0);
            if (this.tail == null) {
                this.head = this.tail = e;
            } else {
                e.addAfter(this.tail);
            }
            this.tail = e;
            ++this.size;
        }

        TransactionStackElement getHead() {
            return this.head;
        }

        TransactionStackElement getTail() {
            Assertion.wilyAssert(this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0);
            return this.tail;
        }

        public int getSize() {
            return this.size;
        }

        TransactionStackElement removeLast() {
            Assertion.wilyAssert(this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0);
            TransactionStackElement result = this.tail;
            if (result != null) {
                this.tail = result.fPrevious;
                if (this.tail != null) {
                    this.tail.fNext = null;
                } else {
                    this.head = null;
                }
                --this.size;
            }
            return result;
        }

        boolean isEmpty() {
            Assertion.wilyAssert(this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0);
            return this.size == 0;
        }

        int size() {
            Assertion.wilyAssert(this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0);
            return this.size;
        }
    }

    private final class TransactionStackElement {
        private final TransactionRecordingBlameStack fParent;
        final String fComponent;
        private final long fStartTime;
        private List fSubElements;
        public IComponentParameterCallback fCallback;
        public ParameterGatheringCallback fParamCallback;
        HashMap fParams;
        TransactionStackElement fPrevious;
        TransactionStackElement fNext;

        public TransactionStackElement(TransactionRecordingBlameStack parent, String component, IComponentParameterCallback callback) {
            this.fParent = parent;
            this.fComponent = component;
            this.fStartTime = MasterClock.currentTimeMillis();
            this.fCallback = callback;
            this.fParamCallback = null;
            this.fSubElements = null;
            this.fNext = null;
            this.fPrevious = null;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public void setParameters(HashMap parameters) {
            this.fParams = parameters;
        }

        public HashMap getParameters() {
            return this.fParams;
        }

        public String getComponent() {
            return this.fComponent;
        }

        public void addSubElement(TransactionComponentData elementData) {
            if (this.fSubElements == null) {
                this.fSubElements = new ArrayList();
            }
            this.fSubElements.add(elementData);
        }

        void addAfter(TransactionStackElement oldTail) {
            oldTail.fNext = this;
            this.fPrevious = oldTail;
            this.fNext = null;
        }

        TransactionStackElement getPrevious() {
            return this.fPrevious;
        }

        public TransactionComponentData finish(boolean shouldIncludeOneTimeParams) {
            long finishTime = MasterClock.currentTimeMillis();
            long duration = finishTime - this.fStartTime;
            TransactionComponentData[] subElements = null;
            if (this.fSubElements != null) {
                subElements = new TransactionComponentData[this.fSubElements.size()];
                subElements = this.fSubElements.toArray(subElements);
            }
            HashMap<String, String> parameters = new HashMap<String, String>(3);
            this.fParent.addCallbackParameters(this.fCallback, parameters);
            if (shouldIncludeOneTimeParams) {
                this.includeOneTimeParams(parameters);
            }
            return new TransactionComponentData(this.fComponent, this.fStartTime, duration, parameters, subElements);
        }

        public void addCallbackParams(String paramName, String paramValue) {
            if (this.fParamCallback == null) {
                this.fParamCallback = new ParameterGatheringCallback();
                this.fCallback = new CompoundComponentParameterCallback(this.fCallback, this.fParamCallback);
            }
            this.fParamCallback.addParameter(paramName, paramValue);
        }

        private void includeCorParams(HashMap parameters) {
            String corid;
            SharedCrossProcessData cache = TransactionRecordingBlameStack.this.agent.IAgent_getComponentTracer().getCrossProcessDataCache();
            if (cache != null && (corid = cache.getCorrelationID()) != null) {
                String seqid;
                parameters.put("CorCrossProcessData", corid);
                SequenceId id = cache.getSeqID();
                if (id != null && (seqid = id.getSequenceId()) != null) {
                    parameters.put("SeqNoCrossProcessData", seqid);
                }
                String txnTraceId = cache.getStringParamIn("TxnTraceId");
                if (TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller GUID " + txnTraceId);
                }
                if (txnTraceId != null) {
                    parameters.put("CallerTxnTraceId", txnTraceId);
                }
                if (TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my GUID " + TransactionRecordingBlameStack.this.fTransactionIdentity);
                }
                parameters.put("TxnTraceId", TransactionRecordingBlameStack.this.fTransactionIdentity);
                String callerTxnTime = cache.getStringParamIn("CallerTimestamp");
                if (TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller's timestamp " + callerTxnTime);
                }
                if (callerTxnTime != null) {
                    parameters.put("CallerTimestamp", callerTxnTime);
                }
                String nonBlockTxn = cache.getStringParamIn("NBThreadTxn");
                if (TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    TransactionRecordingBlameStack.this.agent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current Txn Non Blocking = " + nonBlockTxn);
                }
                if (nonBlockTxn != null) {
                    parameters.put("NBThreadTxn", nonBlockTxn);
                }
            }
        }

        private void includeOneTimeParams(HashMap parameters) {
            String threadGroupName;
            parameters.put("Trace Type", "Normal");
            String threadName = InvocationData.limitSize(Thread.currentThread().getName());
            if (threadName != null) {
                parameters.put("Thread Name", threadName);
            }
            if ((threadGroupName = InvocationData.limitSize(Thread.currentThread().getThreadGroup().getName())) != null) {
                parameters.put("Thread Group Name", threadGroupName);
            }
            this.includeCorParams(parameters);
            if (this.fParent.fURL != null) {
                parameters.put("URL", this.fParent.fURL);
            }
        }
    }
}

