/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class AggregateClassLoader
extends ClassLoader {
    private static final Map<ClassLoader, AggregateClassLoader> instance = new HashMap<ClassLoader, AggregateClassLoader>();
    private static final Set<String> loadersToAggregate = new HashSet<String>();

    private AggregateClassLoader(ClassLoader parent) {
        super(parent);
    }

    private static AggregateClassLoader getInstance(ClassLoader loader) {
        ClassLoader parent = loader.getParent();
        if (!instance.containsKey(parent)) {
            instance.put(parent, new AggregateClassLoader(parent));
        }
        return instance.get(parent);
    }

    public static ClassLoader substituteAggregateClassLoaderIfNeeded(ClassLoader loader) {
        if (loader != null && loadersToAggregate.contains(loader.getClass().getName())) {
            return AggregateClassLoader.getInstance(loader);
        }
        return loader;
    }

    static {
        loadersToAggregate.add("org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader");
    }
}

