/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.TransformerNotAvailableException;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationFilter;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.api.instrument.ClassInfo;
import com.wily.introscope.api.instrument.DGRuntimeClass;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class ContinuousRetransformer
extends Thread {
    public static Method findLoadedClass = null;
    private Module kModule = new Module("ContinuousRetransformer");
    private static ConcurrentLinkedQueue<ClassInfo> continuousRetransformQ;
    private Queue<Class<?>> retransformQ;
    private HashSet<String> classFilter;
    private IDynamicInstrumentationTransformer transformer;
    private IDynamicInstrumentationFilter filter;
    private Instrumentation instrumentation;
    private IModuleFeedbackChannel logger;
    private int intervalInSeconds;
    private int batchSize;
    private static boolean isCPUTimingEnabled;
    private static ThreadMXBean threadBean;
    private static Pattern pattern;
    private static boolean redefineLambdaClasses;
    private static boolean isThreadCpuTimeSupported;
    private static boolean attemptFullBatchRetransform;
    private static boolean batchByClassesQualified;

    public static boolean checkToSkipLambdaClass(String className) {
        if (redefineLambdaClasses) {
            return false;
        }
        return pattern.matcher(className).find();
    }

    public ContinuousRetransformer(Instrumentation instrumentation, IAgent agent) throws TransformerNotAvailableException {
        continuousRetransformQ = new ConcurrentLinkedQueue();
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String propValue = props.getProperty("com.wily.introscope.redefine.lambda.classes");
        if (propValue == null) {
            propValue = System.getProperty("com.wily.introscope.redefine.lambda.classes", "false");
        }
        attemptFullBatchRetransform = props.getBooleanProperty("com.wily.introscope.agent.full.retransform.batch", true);
        batchByClassesQualified = props.getBooleanProperty("com.wily.introscope.agent.retransform.batch.qualified", true);
        redefineLambdaClasses = Boolean.parseBoolean(propValue);
        this.retransformQ = new LinkedList();
        this.classFilter = new HashSet();
        this.transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        if (this.transformer == null) {
            throw new TransformerNotAvailableException();
        }
        this.filter = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter();
        this.instrumentation = instrumentation;
        this.logger = agent.IAgent_getModuleFeedback();
        this.intervalInSeconds = props.getIntProperty("com.wily.introscope.agent.retransform.interval", 2);
        this.batchSize = props.getIntProperty("com.wily.introscope.agent.retransform.batchsize", 200);
        isCPUTimingEnabled = props.getBooleanProperty("com.wily.introscope.agent.retransform.cputime.log", false);
    }

    public static void addClass(String className, ClassLoader loader) {
        if (continuousRetransformQ != null) {
            continuousRetransformQ.offer(new ClassInfo(className, loader));
        }
    }

    private boolean shouldNotSkipClass(String className) {
        return this.filter.shouldNotSkip(className);
    }

    private boolean shouldRetransform(Class<?> clazz) {
        try {
            DGRuntimeClass c = new DGRuntimeClass(clazz);
            if (this.filter.isLikelyToChangeIfRetransformed(c)) {
                return true;
            }
            if (this.transformer.hasTransformationMutations(c)) {
                return true;
            }
        }
        catch (InvalidClassNameException invalidClassNameException) {
            // empty catch block
        }
        return false;
    }

    private List<Class<?>> getBootstrapSortedClasses(Class<?>[] classes) {
        ArrayList bootstrapClasses = new ArrayList();
        ArrayList regularClasses = new ArrayList();
        List priority = this.transformer.getAllBootstrapInstrumentationClasses();
        for (Class<?> clas : classes) {
            if (priority.contains(clas.getName().replace('.', '/'))) {
                bootstrapClasses.add(clas);
                continue;
            }
            regularClasses.add(clas);
        }
        bootstrapClasses.addAll(regularClasses);
        regularClasses.clear();
        return bootstrapClasses;
    }

    private void loadThreadMXBean() {
        try {
            threadBean = ManagementFactory.getThreadMXBean();
            if (threadBean != null) {
                if (threadBean.isThreadCpuTimeSupported()) {
                    isThreadCpuTimeSupported = true;
                } else {
                    this.logger.info(this.kModule, "ThreadCpuTime is not supported");
                }
            } else {
                this.logger.info(this.kModule, "Null ThreadMXBean returned from the ManagementFactory");
            }
        }
        catch (Throwable t) {
            this.logger.error(this.kModule, "Unable to load ManagementFactory", t);
        }
    }

    @Override
    public void run() {
        if (isCPUTimingEnabled) {
            this.loadThreadMXBean();
        }
        this.logger.info(this.kModule, "Starting Continuous Retransformer with interval(seconds): " + this.intervalInSeconds + " and batchsize: " + this.batchSize);
        this.logger.debug(this.kModule, "Adding loaded classes to one time retransform queue");
        this.retransformQ.addAll(this.getBootstrapSortedClasses(this.instrumentation.getAllLoadedClasses()));
        this.logger.debug(this.kModule, this.retransformQ.size() + " previously loaded Classes obtained from instrumentation API");
        int batchCount = 0;
        int qualifiedCount = 0;
        long totalCheckedClasses = 0L;
        while (true) {
            Class<Object> clazz;
            ClassInfo classInfo;
            boolean isDebug = this.logger.isDebugEnabled(this.kModule);
            boolean isTrace = this.logger.isTraceEnabled(this.kModule);
            try {
                if (isDebug) {
                    this.logger.debug(this.kModule, "Sleeping for " + this.intervalInSeconds + " seconds");
                }
                ContinuousRetransformer.sleep(this.intervalInSeconds * 1000);
            }
            catch (InterruptedException ie) {
                this.logger.debug(this.kModule, "Woken up by Interrupt");
                this.logger.trace(this.kModule, "Stacktrace \n", ie);
            }
            long currentTime = System.nanoTime();
            batchCount = 0;
            int checkedCount = 0;
            boolean foundClassToCheck = false;
            ArrayList<Class<?>> batch = new ArrayList(this.batchSize);
            long totalQualificationTime = 0L;
            long batchCheckStartTime = System.nanoTime();
            while (batchCount < this.batchSize && (classInfo = continuousRetransformQ.poll()) != null) {
                try {
                    boolean qualified;
                    foundClassToCheck = true;
                    ++totalCheckedClasses;
                    ++checkedCount;
                    if (!batchByClassesQualified) {
                        ++batchCount;
                    }
                    if ((classInfo.className == null || !this.shouldNotSkipClass(classInfo.className)) && (classInfo.className == null || this.classFilter.contains(classInfo.className) || classInfo.className.startsWith("com.wily") || classInfo.loader != null && classInfo.loader.toString().startsWith("com.wily"))) {
                        if (!isTrace) continue;
                        this.logger.trace(this.kModule, "Class being skipped " + classInfo.className);
                        continue;
                    }
                    if (currentTime - classInfo.timeInNano < 2000000000L) {
                        try {
                            if (isDebug) {
                                this.logger.debug(this.kModule, "Sleeping 2 seconds before retransforming");
                            }
                            ContinuousRetransformer.sleep(2000L);
                            currentTime += 2000000000L;
                        }
                        catch (InterruptedException ie) {
                            this.logger.debug(this.kModule, "Woken up by Interrupt while waiting 2 seconds");
                            this.logger.trace(this.kModule, "Stacktrace \n", ie);
                        }
                    }
                    if (isTrace) {
                        this.logger.trace(this.kModule, "Checking if class " + classInfo.className + " can be retransformed");
                    }
                    if ((clazz = classInfo.loader == null ? Class.forName(classInfo.className, false, null) : (Class<Object>)findLoadedClass.invoke((Object)classInfo.loader, classInfo.className)) == null) {
                        if (!isTrace) continue;
                        this.logger.trace(this.kModule, "Could not get class reference for class name " + classInfo.className + " in loader " + classInfo.loader);
                        continue;
                    }
                    boolean bl = qualified = this.instrumentation.isModifiableClass(clazz) && this.filter.canRedefine(clazz) && this.shouldRetransform(clazz);
                    if (qualified) {
                        ++qualifiedCount;
                        if (batchByClassesQualified) {
                            ++batchCount;
                        }
                        batch.add(clazz);
                        continue;
                    }
                    if (!isTrace) continue;
                    this.logger.trace(this.kModule, "Class didn't qualify " + classInfo.className);
                }
                catch (ClassNotFoundException cnfe) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "Class not found " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "No Class Def found " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", ncdfe);
                }
                catch (Throwable t) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "Failed to retransform class " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", t);
                }
            }
            if (checkedCount > 0) {
                totalQualificationTime = System.nanoTime() - batchCheckStartTime;
                this.logger.info(this.kModule, "It took " + totalQualificationTime / 1000000L + "ms to qualify for reinstrumentation " + batch.size() + " out of " + checkedCount + " checked classes.");
            }
            this.retransformBatch(batch);
            totalQualificationTime = 0L;
            checkedCount = 0;
            batchCheckStartTime = System.nanoTime();
            batch = new ArrayList(this.batchSize);
            while (batchCount < this.batchSize && (clazz = this.retransformQ.poll()) != null) {
                boolean qualified;
                foundClassToCheck = true;
                ++totalCheckedClasses;
                ++checkedCount;
                if (!batchByClassesQualified) {
                    ++batchCount;
                }
                String className = clazz.getName();
                if (DeepInheritanceHelper.isDebugOn && DeepInheritanceHelper.debugForClass.contains(DeepInheritanceHelper.classNameForest.addAndGetID(className))) {
                    System.out.print("");
                }
                if (!(className != null && this.shouldNotSkipClass(className) || className != null && !ContinuousRetransformer.checkToSkipLambdaClass(className) && !className.startsWith("com.wily"))) {
                    if (!isTrace) continue;
                    this.logger.trace(this.kModule, "Already loaded class being skipped " + className);
                    continue;
                }
                if (isTrace) {
                    this.logger.trace(this.kModule, "Checking if previously loaded class " + className + " can be retransformed");
                }
                boolean bl = qualified = this.instrumentation.isModifiableClass(clazz) && this.filter.canRedefine(clazz) && this.shouldRetransform(clazz);
                if (qualified) {
                    ++qualifiedCount;
                    if (batchByClassesQualified) {
                        ++batchCount;
                    }
                    batch.add(clazz);
                    if (!isDebug) continue;
                    this.logger.debug(this.kModule, "retransformQ: Retransforming previously loaded class " + className);
                    continue;
                }
                if (!isTrace) continue;
                this.logger.trace(this.kModule, "Already loaded class did not qualify " + className);
            }
            if (checkedCount > 0) {
                totalQualificationTime = System.nanoTime() - batchCheckStartTime;
                this.logger.info(this.kModule, "It took " + totalQualificationTime / 1000000L + "ms to qualify for reinstrumentation " + batch.size() + " out of " + checkedCount + " checked classes.");
            }
            this.retransformBatch(batch);
            if (!foundClassToCheck) continue;
            this.logger.info(this.kModule, "Retransformed " + qualifiedCount + " classes out of a total of " + totalCheckedClasses + " classes");
        }
    }

    private void retransformBatch(List<Class<?>> batch) {
        if (batch.isEmpty()) {
            return;
        }
        if (attemptFullBatchRetransform) {
            try {
                long processingTime = 0L;
                long cpuprocessingTime = 0L;
                processingTime = System.nanoTime();
                if (isThreadCpuTimeSupported) {
                    cpuprocessingTime = threadBean.getCurrentThreadCpuTime();
                }
                this.logger.info(this.kModule, "Retransforming a batch of " + batch.size() + " classes.");
                this.instrumentation.retransformClasses(batch.toArray(new Class[0]));
                if (isThreadCpuTimeSupported) {
                    this.logger.info(this.kModule, "Total time took for batch transformation, time(ms):" + (System.nanoTime() - processingTime) / 1000000L + " , cpuTime(ms):" + (threadBean.getCurrentThreadCpuTime() - cpuprocessingTime) / 1000000L);
                } else {
                    this.logger.info(this.kModule, "Total time took for batch transformation, time(ms):" + (System.nanoTime() - processingTime) / 1000000L);
                }
                return;
            }
            catch (UnmodifiableClassException uce) {
                this.logger.debug(this.kModule, "Failed to retransform batch of classes. " + uce.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", uce);
            }
            catch (InternalError ie) {
                this.logger.debug(this.kModule, "Failed to retransform batch of classes. " + ie.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", ie);
            }
            catch (Throwable t) {
                this.logger.debug(this.kModule, "Failed to retransform batch of classes. " + t.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", t);
            }
        }
        long processingTime = 0L;
        long cpuprocessingTime = 0L;
        processingTime = System.nanoTime();
        if (isThreadCpuTimeSupported) {
            cpuprocessingTime = threadBean.getCurrentThreadCpuTime();
        }
        this.logger.info(this.kModule, "Retransforming a batch of " + batch.size() + " classes one by one.");
        for (Class<?> clazz : batch) {
            try {
                this.instrumentation.retransformClasses(clazz);
            }
            catch (UnmodifiableClassException uce) {
                this.logger.debug(this.kModule, "Failed to retransform class " + clazz.getCanonicalName() + ": " + uce.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", uce);
            }
            catch (InternalError ie) {
                this.logger.debug(this.kModule, "Failed to retransform class " + clazz.getCanonicalName() + ": " + ie.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", ie);
            }
            catch (Throwable t) {
                this.logger.debug(this.kModule, "Failed to retransform class " + clazz.getCanonicalName() + ": " + t.getMessage());
                this.logger.trace(this.kModule, "Stacktrace \n", t);
            }
        }
        if (isThreadCpuTimeSupported) {
            this.logger.info(this.kModule, "Total time took for batch transformation one by one, time(ms):" + (System.nanoTime() - processingTime) / 1000000L + " , cpuTime(ms):" + (threadBean.getCurrentThreadCpuTime() - cpuprocessingTime) / 1000000L);
        } else {
            this.logger.info(this.kModule, "Total time took for batch transformation one by one, time(ms):" + (System.nanoTime() - processingTime) / 1000000L);
        }
    }

    static {
        pattern = Pattern.compile("\\$\\$Lambda\\$[0-9]");
        redefineLambdaClasses = false;
        isThreadCpuTimeSupported = false;
        attemptFullBatchRetransform = true;
        batchByClassesQualified = true;
    }
}

