/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentFactoryThread;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.api.instrument.AggregateClassLoader;
import com.wily.introscope.api.instrument.FakeClassLoader;
import com.wily.introscope.api.instrument.Pair;
import com.wily.util.StringIndexer;
import com.wily.util.adt.ConcurrentWeakIdentityThreadLocalHashMap;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.adt.primitive.IntHashSet;
import com.wily.util.adt.primitive.IntObjHashMap;
import com.wily.util.adt.primitive.IntSetEntry;
import com.wily.util.adt.primitive.PrimitiveIntObjMap;
import com.wily.util.adt.primitive.PrimitiveIntSet;
import com.wily.util.adt.primitive.Synchronizer;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.extension.EagerAllPermissionsClassLoader;
import com.wily.util.extension.JarExtension;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DeepInheritanceHelper {
    public static boolean onlyDeep = Boolean.parseBoolean(System.getProperty("com.wily.introscope.agent.deepinheritance.onlyDeep", "false"));
    public static final StringIndexer classNameForest = new StringIndexer();
    public static volatile boolean isDebugOn = false;
    public static volatile PrimitiveIntSet debugForClass = null;
    public static volatile PrimitiveIntSet debugForRoot = null;
    public static volatile boolean isDebugLog = false;
    private static boolean isInitialized = false;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntObjMap<List<PrimitiveIntSet>>> classForest;
    private static final int PARENTS_INDEX = 0;
    private static final int SUBCLASSES_INDEX = 1;
    private static final int INSTRUMENTED_INDEX = 2;
    private static final int ANNOTATIONS_INDEX = 3;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> annotationForest;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, WeakHashSet> classLoaderHierarchy;
    private static PrimitiveIntObjMap<ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet>> parentNotFound;
    private static PrimitiveIntSet rootNotFound;
    private static PrimitiveIntSet shallowRootNotFound;
    private static PrimitiveIntObjMap<Set<ClassLoader>> classesBeingRetransformed;
    private static Lock retransformationLock;
    private static final Module kModule;
    private static IModuleFeedbackChannel logger;
    private static IAgent agent;
    private static IClassRedefinitionDelegate instrumentationDelegate;
    public static IntervalHeartbeat heartbeat;
    private static final ClassLoader bootstrapClassLoader;
    private static IDynamicInstrumentationTransformer transformer;
    private static PrimitiveIntObjMap<List<PrimitiveIntSet>> bootstrapClassLoaderMap;

    public static void initialize(IAgent ag) {
        agent = ag;
        transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        isDebugOn = Boolean.parseBoolean(props.getProperty("com.wily.introscope.agent.deepinheritance.debugOn", "false"));
        if (isDebugOn) {
            debugForClass = new IntHashSet(0, 1.0f);
            debugForRoot = new IntHashSet(0, 1.0f);
            for (String className : props.getProperty("com.wily.introscope.agent.deepinheritance.debugClasses", "").split(",")) {
                if ((className = className.trim()).length() <= 0) continue;
                debugForClass.add(classNameForest.addAndGetID(className));
            }
            for (String rootName : props.getProperty("com.wily.introscope.agent.deepinheritance.debugRoots", "").split(",")) {
                if ((rootName = rootName.trim()).length() <= 0) continue;
                debugForRoot.add(classNameForest.addAndGetID(rootName));
            }
        }
        instrumentationDelegate = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getClassRedefinitionDelegate();
        heartbeat = agent.IAgent_getAsyncInstrumentationHeartbeat();
        logger = agent.IAgent_getModuleFeedback();
        isDebugLog = logger.isDebugEnabled(kModule);
        classForest = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        annotationForest = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        classLoaderHierarchy = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        parentNotFound = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
        rootNotFound = Synchronizer.synchronizedPrimitiveIntSet(new IntHashSet(0, 1.0f));
        shallowRootNotFound = Synchronizer.synchronizedPrimitiveIntSet(new IntHashSet(0, 1.0f));
        classesBeingRetransformed = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
        retransformationLock = new ReentrantLock();
        AgentFactoryThread initForestThread = new AgentFactoryThread(null, new Runnable(){

            @Override
            public void run() {
                DeepInheritanceHelper.initForest();
            }
        }, "Agent: DeepInheritanceInitializer");
        initForestThread.setDaemon(true);
        initForestThread.start();
        isInitialized = true;
    }

    private static void populateClassLoaderHierarchy(ClassLoader classLoader) {
        while (classLoader != null && classLoader != bootstrapClassLoader) {
            WeakHashSet temp;
            ClassLoader parent = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded((classLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(classLoader)).getParent());
            if (parent == null) {
                parent = bootstrapClassLoader;
            }
            if ((temp = classLoaderHierarchy.getWeak(parent)) == null) {
                temp = new WeakHashSet();
                classLoaderHierarchy.putWeak(parent, temp);
            }
            if (temp.contains(classLoader)) break;
            temp.add(classLoader);
            if (parent == bootstrapClassLoader) break;
            classLoader = parent;
        }
    }

    private static Set<ClassLoader> getAllPossibleSubclassClassLoaders(ClassLoader parentClassClassLoader) {
        if (parentClassClassLoader == null) {
            parentClassClassLoader = bootstrapClassLoader;
        }
        HashSet<ClassLoader> returnSet = new HashSet<ClassLoader>();
        LinkedList<ClassLoader> children = new LinkedList<ClassLoader>();
        children.add(parentClassClassLoader);
        while (children.peek() != null) {
            ClassLoader child = (ClassLoader)children.poll();
            returnSet.add(child);
            WeakHashSet directChildren = classLoaderHierarchy.getWeak(child);
            if (directChildren == null) continue;
            children.addAll(directChildren.keySet());
        }
        return returnSet;
    }

    private static ClassLoader getRelevantClassLoaderForParentClass(int className, ClassLoader startingPoint) {
        while (true) {
            PrimitiveIntObjMap<List<PrimitiveIntSet>> map;
            if ((startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) == null) {
                startingPoint = bootstrapClassLoader;
            }
            if ((map = classForest.getWeak(startingPoint)) != null && map.containsKey(className)) {
                return startingPoint;
            }
            if (startingPoint == bootstrapClassLoader) {
                return null;
            }
            startingPoint = startingPoint.getParent();
        }
    }

    private static boolean shouldProcessForAnnotations(PrimitiveIntSet annotations) {
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        IntHashSet temp = new IntHashSet();
        for (IntSetEntry entry : annotations) {
            int anno = entry.getValue();
            if (!rootNotFound.contains(anno) && !shallowRootNotFound.contains(anno)) continue;
            temp.add(anno);
        }
        return temp.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addClass(int thisClassName, ClassLoader thisClassLoader, PrimitiveIntSet parents, PrimitiveIntSet directSubclasses, PrimitiveIntSet instrumentedFor, PrimitiveIntSet annotations, boolean isClassBeingLoaded) {
        ClassLoader realClassLoader = thisClassLoader;
        if (thisClassLoader == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(thisClassLoader);
        DeepInheritanceHelper.populateClassLoaderHierarchy(thisClassLoader);
        PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap = classForest.getWeak(thisClassLoader);
        if (classMap == null) {
            classMap = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
            classForest.putWeak(thisClassLoader, classMap);
        }
        PrimitiveIntObjMap<List<PrimitiveIntSet>> primitiveIntObjMap = classMap;
        synchronized (primitiveIntObjMap) {
            List<PrimitiveIntSet> tempList = classMap.get(thisClassName);
            if (tempList != null && tempList.get(1) != null) {
                if (directSubclasses == null) {
                    directSubclasses = new IntHashSet(tempList.get(1).size(), 1.0f);
                }
                for (IntSetEntry entry : tempList.get(1)) {
                    directSubclasses.add(entry.getValue());
                }
            }
            classMap.put(thisClassName, Arrays.asList(parents, directSubclasses, instrumentedFor, annotations));
        }
        if (annotations != null && annotations.size() > 0) {
            Object tempSet = annotationForest.getWeak(thisClassLoader);
            if (tempSet == null) {
                tempSet = new IntHashSet(0, 1.0f);
                annotationForest.putWeak(thisClassLoader, (PrimitiveIntSet)tempSet);
            }
            for (IntSetEntry entry : annotations) {
                tempSet.add(entry.getValue());
            }
        }
        if (parents != null) {
            for (IntSetEntry entry : parents) {
                int name = entry.getValue();
                ClassLoader loader = DeepInheritanceHelper.getRelevantClassLoaderForParentClass(name, thisClassLoader);
                if (loader == null) {
                    ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> map;
                    PrimitiveIntObjMap<ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet>> primitiveIntObjMap2 = parentNotFound;
                    synchronized (primitiveIntObjMap2) {
                        map = parentNotFound.get(name);
                        if (map == null) {
                            map = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
                            parentNotFound.put(name, map);
                        }
                    }
                    PrimitiveIntSet subclasses = map.getWeak(thisClassLoader);
                    if (subclasses == null) {
                        subclasses = new IntHashSet(0, 1.0f);
                        map.putWeak(thisClassLoader, subclasses);
                    }
                    subclasses.add(thisClassName);
                    continue;
                }
                PrimitiveIntSet subclasses = classForest.getWeak(loader).get(name).get(1);
                if (subclasses == null) {
                    subclasses = new IntHashSet(0, 1.0f);
                    classForest.getWeak(loader).get(name).set(1, subclasses);
                }
                subclasses.add(thisClassName);
            }
        }
        if (parentNotFound.containsKey(thisClassName)) {
            PrimitiveIntSet subclasses = classForest.getWeak(thisClassLoader).get(thisClassName).get(1);
            if (subclasses == null) {
                subclasses = new IntHashSet(0, 1.0f);
                classForest.getWeak(thisClassLoader).get(thisClassName).set(1, subclasses);
            }
            ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> possibleSubclasses = parentNotFound.get(thisClassName);
            for (ClassLoader loader : DeepInheritanceHelper.getAllPossibleSubclassClassLoaders(thisClassLoader)) {
                if (!possibleSubclasses.containsWeakKey(loader)) continue;
                for (IntSetEntry entry : possibleSubclasses.getWeak(loader)) {
                    subclasses.add(entry.getValue());
                }
                possibleSubclasses.removeWeak(loader);
            }
            if (possibleSubclasses.size() == 0) {
                parentNotFound.remove(thisClassName);
                possibleSubclasses.markForGC();
            }
        }
        if (!isClassBeingLoaded) {
            retransformationLock.lock();
            if (!(!rootNotFound.contains(thisClassName) && !DeepInheritanceHelper.shouldProcessForAnnotations(annotations) || !instrumentationDelegate.isClassRetransformationSupported() || classesBeingRetransformed.containsKey(thisClassName) && classesBeingRetransformed.get(thisClassName).contains(realClassLoader))) {
                SubtreeRetransformer retransformClasses = new SubtreeRetransformer(thisClassName, thisClassLoader, false);
                heartbeat.addBehavior(retransformClasses, "Retransforming Classes for Deep Inheritance", true, 2000L, false, 1);
            }
            retransformationLock.unlock();
        }
    }

    public static void addClass(Class<?> c) {
        String name;
        if (!isInitialized) {
            return;
        }
        if (c == null) {
            return;
        }
        ClassLoader thisClassLoader = c.getClassLoader();
        int thisClassName = classNameForest.addAndGetID(c.getName());
        IntHashSet parents = null;
        PrimitiveIntSet directSubclasses = null;
        PrimitiveIntSet instrumentedFor = null;
        IntHashSet annotations = null;
        Class<?> parent = c.getSuperclass();
        if (parent != null && !(name = parent.getName()).equals("java.lang.Object")) {
            parents = new IntHashSet(c.getInterfaces().length + 1, 1.0f);
            parents.add(classNameForest.addAndGetID(name));
        }
        if (c.getInterfaces().length > 0 && parents == null) {
            parents = new IntHashSet(c.getInterfaces().length, 1.0f);
        }
        for (Class<?> clazz : c.getInterfaces()) {
            parents.add(classNameForest.addAndGetID(clazz.getName()));
        }
        try {
            if (c.getDeclaredAnnotations().length > 0) {
                annotations = new IntHashSet(c.getDeclaredAnnotations().length, 1.0f);
            }
            for (Annotation annotation : c.getDeclaredAnnotations()) {
                annotations.add(classNameForest.addAndGetID(annotation.annotationType().getName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DeepInheritanceHelper.addClass(thisClassName, thisClassLoader, parents, directSubclasses, instrumentedFor, annotations, false);
    }

    public static void addClass(IModeledClass c) {
        if (!isInitialized) {
            return;
        }
        if (c == null) {
            return;
        }
        ClassLoader thisClassloader = c.getClassLoader();
        int thisClassName = classNameForest.addAndGetID("Unnamed Class");
        try {
            thisClassName = classNameForest.addAndGetID(c.getClassName().getReflectionFriendlyQualifiedNameString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        IntHashSet parents = null;
        PrimitiveIntSet directSubclasses = null;
        PrimitiveIntSet instrumentedFor = null;
        IntHashSet annotations = null;
        String superClassName = null;
        try {
            superClassName = c.getSuperClassName().getReflectionFriendlyQualifiedNameString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (superClassName != null && !superClassName.equals("java.lang.Object")) {
            parents = new IntHashSet(c.getAllImplementedInterfaceNames().size() + 1, 1.0f);
            parents.add(classNameForest.addAndGetID(superClassName));
        }
        if (c.getAllImplementedInterfaceNames().size() > 0) {
            if (parents == null) {
                parents = new IntHashSet(c.getAllImplementedInterfaceNames().size(), 1.0f);
            }
            for (String interfaceName : c.getAllImplementedInterfaceNames()) {
                parents.add(classNameForest.addAndGetID(interfaceName));
            }
        }
        if (c.getAllDeclaredAnnotationNames().size() > 0) {
            annotations = new IntHashSet(c.getAllDeclaredAnnotationNames().size(), 1.0f);
            for (String annotationName : c.getAllDeclaredAnnotationNames()) {
                annotations.add(classNameForest.addAndGetID(annotationName));
            }
        }
        DeepInheritanceHelper.addClass(thisClassName, thisClassloader, parents, directSubclasses, instrumentedFor, annotations, true);
    }

    private static void initForest() {
        for (Class c : instrumentationDelegate.getAllLoadedClasses()) {
            DeepInheritanceHelper.addClass(c);
        }
    }

    private static void updateInstrumentedFor(ClassLoader loader, int classId, int rootName) {
        ClassLoader realLoader = loader;
        if (loader == null) {
            loader = bootstrapClassLoader;
        }
        try {
            boolean changeInInstrumentation;
            PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap = classForest.getWeak(loader);
            if (classMap == null) {
                return;
            }
            List<PrimitiveIntSet> classInfo = classMap.get(classId);
            if (classInfo == null) {
                logger.debug(kModule, "Class with Id " + classId + "is missing from map during instrumentation.");
                return;
            }
            PrimitiveIntSet instrumentedFor = classInfo.get(2);
            if (instrumentedFor == null) {
                instrumentedFor = new IntHashSet(0, 1.0f);
                classInfo.set(2, instrumentedFor);
            }
            int origSize = instrumentedFor.size();
            instrumentedFor.add(rootName);
            boolean bl = changeInInstrumentation = origSize != instrumentedFor.size();
            if (!(!changeInInstrumentation || classInfo.get(1) == null || classInfo.get(1).size() <= 0 || classesBeingRetransformed.containsKey(classId) && classesBeingRetransformed.get(classId).contains(realLoader))) {
                SubtreeRetransformer retransformClasses = new SubtreeRetransformer(classId, loader, true, rootName);
                heartbeat.addBehavior(retransformClasses, "Retransforming Classes for Deep Inheritance", true, 2000L, false, 1);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static boolean runMatch(int rootId, ClassLoader loader, String className, IModeledClass classToMatch, PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap, boolean shouldMatchShallow, boolean isRootAnAnnotation, boolean isDebug) {
        int thisClassId = classNameForest.addAndGetID(className);
        List<PrimitiveIntSet> classInfo = classMap.get(thisClassId);
        if (classInfo == null) {
            if (isDebug) {
                logger.debug(kModule, "runMatch() failed to find class info in cache for " + className + " with class Id " + thisClassId);
            }
            return false;
        }
        if (isRootAnAnnotation) {
            if (classInfo.get(3) != null && classInfo.get(3).contains(rootId)) {
                if (shouldMatchShallow && classInfo.get(1) != null && classInfo.get(1).size() > 0) {
                    SubtreeRetransformer shallowRetransform = new SubtreeRetransformer(thisClassId, loader, true, rootId, true);
                    heartbeat.addBehavior(shallowRetransform, "Shallow Retransformation for annotations", true, 2000L, false, 1);
                }
                return true;
            }
        } else if (thisClassId == rootId) {
            return !shouldMatchShallow;
        }
        if (classInfo.get(0) != null) {
            LinkedList<Object> levelOrderTraversalQ = new LinkedList<Object>();
            for (IntSetEntry entry : classInfo.get(0)) {
                levelOrderTraversalQ.add(entry.getValue());
            }
            ClassLoader startingPoint = loader;
            block1: while (levelOrderTraversalQ.peek() != null) {
                Object item = levelOrderTraversalQ.poll();
                if (item instanceof ClassLoader) {
                    startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded((ClassLoader)item);
                    continue;
                }
                int parentClassId = (Integer)item;
                if (!isRootAnAnnotation) {
                    if (parentClassId == rootId) {
                        return true;
                    }
                    if (shouldMatchShallow) continue;
                }
                ClassLoader traversalLoader = startingPoint;
                while (true) {
                    PrimitiveIntObjMap<List<PrimitiveIntSet>> traversalClassMap;
                    if (traversalLoader == null) {
                        traversalLoader = bootstrapClassLoader;
                    }
                    if ((traversalClassMap = classForest.getWeak(traversalLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(traversalLoader))) != null && traversalClassMap.containsKey(parentClassId)) {
                        List<PrimitiveIntSet> parentClassInfo = traversalClassMap.get(parentClassId);
                        if (isRootAnAnnotation && parentClassInfo.get(3) != null && parentClassInfo.get(3).contains(rootId)) {
                            return true;
                        }
                        if (!shouldMatchShallow) {
                            if (parentClassInfo.get(2) != null && parentClassInfo.get(2).contains(rootId)) {
                                return true;
                            }
                            levelOrderTraversalQ.offer(traversalLoader);
                            if (parentClassInfo.get(0) != null) {
                                for (IntSetEntry entry : parentClassInfo.get(0)) {
                                    levelOrderTraversalQ.add(entry.getValue());
                                }
                            }
                        }
                    }
                    if (traversalLoader == bootstrapClassLoader) continue block1;
                    traversalLoader = traversalLoader.getParent();
                }
            }
        }
        return false;
    }

    private static boolean isAgentClassLoader(ClassLoader loader) {
        if (loader instanceof JarExtension.AllPermissionsClassLoader) {
            return true;
        }
        if (loader instanceof JarExtension.AllPermissionsClassLoaderChildFirst) {
            return true;
        }
        return loader instanceof EagerAllPermissionsClassLoader;
    }

    private static PrimitiveIntObjMap<List<PrimitiveIntSet>> getClassMapForLoader(ClassLoader loader) {
        if (loader == null || loader == bootstrapClassLoader) {
            if (bootstrapClassLoaderMap == null) {
                bootstrapClassLoaderMap = classForest.getWeak(bootstrapClassLoader);
            }
            return bootstrapClassLoaderMap;
        }
        return classForest.getWeak(loader);
    }

    private static boolean isDirectMatchPossible(int rootId, String className, IModeledClass cls, PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap, boolean isRootAnAnnotation, boolean isDebug) {
        int thisClassId = classNameForest.getIDIfExists(className);
        if (thisClassId == 0) {
            if (isDebug) {
                logger.debug(kModule, "Class info cache miss for " + className);
            }
            DeepInheritanceHelper.addClass(cls);
            thisClassId = classNameForest.getIDIfExists(className);
            if (thisClassId == 0) {
                if (isDebug) {
                    logger.debug(kModule, "Failed to add class info to cache for " + className);
                }
                return false;
            }
        }
        if (!isRootAnAnnotation && thisClassId == rootId) {
            return true;
        }
        List<PrimitiveIntSet> classInfo = classMap.get(thisClassId);
        if (classInfo == null) {
            if (isDebug) {
                logger.debug(kModule, "Failed to find class info in cache for " + className + " with class Id " + thisClassId);
            }
            return false;
        }
        return isRootAnAnnotation ? classInfo.get(3) != null && classInfo.get(3).contains(rootId) : classInfo.get(0) != null && classInfo.get(0).contains(rootId);
    }

    private static synchronized boolean doesRootClassExist(int rootClassName, ClassLoader startingPoint) {
        while (true) {
            if (startingPoint == null) {
                startingPoint = bootstrapClassLoader;
            }
            if (classForest.containsWeakKey(startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) && classForest.getWeak(startingPoint).containsKey(rootClassName)) {
                return true;
            }
            if (startingPoint == bootstrapClassLoader) break;
            startingPoint = startingPoint.getParent();
        }
        rootNotFound.add(rootClassName);
        return false;
    }

    public static boolean matchForClass(int rootClassId, IModeledClass classToMatch, boolean shouldMatchShallow) {
        ClassLoader thisClassLoader;
        if (!isInitialized) {
            return false;
        }
        if (isDebugOn && debugForRoot.contains(rootClassId)) {
            System.out.print("");
        }
        if ((thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(classToMatch.getClassLoader())) == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        if (DeepInheritanceHelper.isAgentClassLoader(thisClassLoader)) {
            return false;
        }
        String qualifiedClassName = classToMatch.getClassName().getReflectionFriendlyQualifiedNameString();
        PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap = DeepInheritanceHelper.getClassMapForLoader(thisClassLoader);
        if (classMap == null) {
            if (isDebugLog) {
                logger.debug(kModule, "Failed to find class map for class loader of " + qualifiedClassName);
            }
            return false;
        }
        if (!(DeepInheritanceHelper.isDirectMatchPossible(rootClassId, qualifiedClassName, classToMatch, classMap, false, isDebugLog) || shouldMatchShallow || DeepInheritanceHelper.doesRootClassExist(rootClassId, thisClassLoader))) {
            return false;
        }
        if (DeepInheritanceHelper.runMatch(rootClassId, thisClassLoader, qualifiedClassName, classToMatch, classMap, shouldMatchShallow, false, isDebugLog)) {
            if (!shouldMatchShallow) {
                int classId = classNameForest.getIDIfExists(qualifiedClassName);
                if (classId == 0) {
                    return true;
                }
                DeepInheritanceHelper.updateInstrumentedFor(thisClassLoader, classId, rootClassId);
            }
            return true;
        }
        return false;
    }

    private static synchronized boolean doesRootAnnotationExist(int rootAnnotationId, ClassLoader startingPoint, boolean isForShallowMatch) {
        while (true) {
            if (startingPoint == null) {
                startingPoint = bootstrapClassLoader;
            }
            if (annotationForest.containsWeakKey(startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) && annotationForest.getWeak(startingPoint).contains(rootAnnotationId)) {
                return true;
            }
            if (startingPoint == bootstrapClassLoader) break;
            startingPoint = startingPoint.getParent();
        }
        if (isForShallowMatch) {
            if (!rootNotFound.contains(rootAnnotationId)) {
                shallowRootNotFound.add(rootAnnotationId);
            }
        } else {
            shallowRootNotFound.remove(rootAnnotationId);
            rootNotFound.add(rootAnnotationId);
        }
        return false;
    }

    public static boolean matchForAnnotation(int rootAnnotationId, IModeledClass classToMatch, boolean shouldMatchShallow) {
        ClassLoader thisClassLoader;
        if (!isInitialized) {
            return false;
        }
        if (isDebugOn && debugForRoot.contains(rootAnnotationId)) {
            System.out.print("");
        }
        if ((thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(classToMatch.getClassLoader())) == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        if (DeepInheritanceHelper.isAgentClassLoader(thisClassLoader)) {
            return false;
        }
        String qualifiedClassName = classToMatch.getClassName().getReflectionFriendlyQualifiedNameString();
        PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap = DeepInheritanceHelper.getClassMapForLoader(thisClassLoader);
        if (classMap == null) {
            if (isDebugLog) {
                logger.debug(kModule, "Failed to find class map for class loader of " + qualifiedClassName);
            }
            return false;
        }
        if (!DeepInheritanceHelper.isDirectMatchPossible(rootAnnotationId, qualifiedClassName, classToMatch, classMap, true, isDebugLog) && !DeepInheritanceHelper.doesRootAnnotationExist(rootAnnotationId, thisClassLoader, shouldMatchShallow)) {
            return false;
        }
        if (DeepInheritanceHelper.runMatch(rootAnnotationId, thisClassLoader, qualifiedClassName, classToMatch, classMap, shouldMatchShallow, false, isDebugLog)) {
            if (!shouldMatchShallow) {
                int classId = classNameForest.getIDIfExists(qualifiedClassName);
                if (classId == 0) {
                    return true;
                }
                DeepInheritanceHelper.updateInstrumentedFor(thisClassLoader, classId, rootAnnotationId);
            }
            return true;
        }
        return false;
    }

    static {
        kModule = new Module("DeepInheritanceHelper");
        bootstrapClassLoader = new FakeClassLoader();
    }

    private static final class SubtreeRetransformer
    implements ITimestampedRunnable {
        private int rootClassName;
        private ClassLoader rootClassLoader;
        private int instrumentFor;
        boolean skipRoot;
        private boolean shallowRetransformation;

        SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = 0;
            this.shallowRetransformation = false;
        }

        public SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot, int instrumentFor) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = instrumentFor;
            this.shallowRetransformation = false;
        }

        public SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot, int instrumentFor, boolean shallowRetransformation) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = instrumentFor;
            this.shallowRetransformation = shallowRetransformation;
        }

        private PrimitiveIntSet calculateInstrumentFor() {
            int annotation;
            boolean hasAnnotations;
            IntHashSet instrumentFor = new IntHashSet();
            if (this.instrumentFor != 0) {
                instrumentFor.add(this.instrumentFor);
            }
            if (rootNotFound.contains(this.rootClassName)) {
                instrumentFor.add(this.rootClassName);
            }
            IntHashSet annotationsToConsider = new IntHashSet();
            boolean bl = hasAnnotations = ((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3) != null;
            if (hasAnnotations) {
                for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3)) {
                    annotation = entry.getValue();
                    if (!rootNotFound.contains(annotation)) continue;
                    annotationsToConsider.add(annotation);
                }
            }
            for (IntSetEntry entry : annotationsToConsider) {
                instrumentFor.add(entry.getValue());
            }
            if (hasAnnotations && instrumentFor.size() == 0) {
                for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3)) {
                    annotation = entry.getValue();
                    if (!shallowRootNotFound.contains(annotation)) continue;
                    annotationsToConsider.add(annotation);
                }
                if (annotationsToConsider.size() > 0) {
                    for (IntSetEntry entry : annotationsToConsider) {
                        instrumentFor.add(entry.getValue());
                    }
                    this.shallowRetransformation = true;
                }
            }
            return instrumentFor;
        }

        private ClassLoader getCommonAncestor(ClassLoader l1, ClassLoader l2) {
            if (l1 == l2) {
                return l1;
            }
            HashSet<ClassLoader> possbileMatches = new HashSet<ClassLoader>();
            while (true) {
                possbileMatches.add(l1);
                if (l1 == null) break;
                l1 = l1.getParent();
            }
            while (!possbileMatches.contains(l2)) {
                l2 = l2.getParent();
            }
            ClassLoader returnLoader = l2;
            if (returnLoader == null) {
                returnLoader = bootstrapClassLoader;
            }
            return AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(returnLoader);
        }

        private LinkedHashMap<Integer, WeakHashMap<ClassLoader, Class<?>>> calculateClassesToInstrument(PrimitiveIntSet instrumentFor) {
            LinkedHashMap classesToInstrument = new LinkedHashMap();
            if (instrumentFor.size() == 0) {
                return classesToInstrument;
            }
            Stack<Pair> nameStack = new Stack<Pair>();
            if (!this.skipRoot) {
                nameStack.push(new Pair(this.rootClassName, 0, this.rootClassLoader));
            }
            if ((this.skipRoot || this.shallowRetransformation) && ((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(1) != null) {
                for (IntSetEntry subclassEntry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(1)) {
                    nameStack.push(new Pair(subclassEntry.getValue(), this.rootClassName, this.rootClassLoader));
                }
            }
            while (!nameStack.empty()) {
                Pair root = (Pair)nameStack.pop();
                int name = root.className;
                int parentName = root.parentClassName;
                ClassLoader rootLoader = root.startingPoint;
                Stack<ClassLoader> loaderStack = new Stack<ClassLoader>();
                loaderStack.push(rootLoader);
                int classesToBeInstrumented = 0;
                ClassLoader nextStartingPoint = null;
                while (!loaderStack.empty()) {
                    WeakHashSet subClassLoaders;
                    ClassLoader loader = (ClassLoader)loaderStack.pop();
                    if (classForest.containsWeakKey(loader) && ((PrimitiveIntObjMap)classForest.getWeak(loader)).containsKey(name) && (parentName == 0 || ((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(0) != null && ((PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(0)).contains(parentName))) {
                        nextStartingPoint = nextStartingPoint == null ? loader : this.getCommonAncestor(nextStartingPoint, loader);
                        IntHashSet instrumentedFor = new IntHashSet(0, 1.0f);
                        if (((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2) != null) {
                            for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2)) {
                                instrumentedFor.add(entry.getValue());
                            }
                        } else {
                            ((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).set(2, new IntHashSet(0, 1.0f));
                        }
                        int origSize = instrumentedFor.size();
                        for (IntSetEntry entry : instrumentFor) {
                            instrumentedFor.add(entry.getValue());
                        }
                        if (instrumentedFor.size() > origSize) {
                            if (!classesToInstrument.containsKey(name)) {
                                classesToInstrument.put(name, new WeakHashMap());
                            }
                            classesToInstrument.get(name).put(loader, null);
                            ++classesToBeInstrumented;
                            if (!this.shallowRetransformation) {
                                for (IntSetEntry entry : instrumentedFor) {
                                    ((PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2)).add(entry.getValue());
                                }
                            }
                        }
                    }
                    if (!classLoaderHierarchy.containsWeakKey(loader) || (subClassLoaders = (WeakHashSet)classLoaderHierarchy.getWeak(loader)) == null) continue;
                    loaderStack.addAll(subClassLoaders.keySet());
                }
                if (classesToBeInstrumented == 0 || this.shallowRetransformation) continue;
                try {
                    if (((List)((PrimitiveIntObjMap)classForest.getWeak(rootLoader)).get(name)).get(1) == null) continue;
                    for (IntSetEntry subclassEntry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(rootLoader)).get(name)).get(1)) {
                        nameStack.push(new Pair(subclassEntry.getValue(), name, nextStartingPoint));
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            return classesToInstrument;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void ITimestampedRunnable_execute(long l) {
            try {
                void var6_8;
                LinkedHashMap<Integer, WeakHashMap<ClassLoader, Class<?>>> classesToInstrument = this.calculateClassesToInstrument(this.calculateInstrumentFor());
                if (classesToInstrument.size() == 0) {
                    return;
                }
                Class[] classArray = instrumentationDelegate.getAllLoadedClasses();
                int n = classArray.length;
                boolean bl = false;
                while (var6_8 < n) {
                    Class c = classArray[var6_8];
                    int classId = classNameForest.getIDIfExists(c.getName());
                    if (classId != 0 && classesToInstrument.containsKey(classId)) {
                        ClassLoader loader = c.getClassLoader() == null ? bootstrapClassLoader : c.getClassLoader();
                        loader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(loader);
                        if (classesToInstrument.get(classId).containsKey(loader)) {
                            classesToInstrument.get(classId).put(loader, c);
                        }
                    }
                    ++var6_8;
                }
                ArrayList optimizedClassesToInstrument = new ArrayList();
                for (WeakHashMap<ClassLoader, Class<?>> weakHashMap : classesToInstrument.values()) {
                    for (Class<?> c : weakHashMap.values()) {
                        if (c == null) continue;
                        optimizedClassesToInstrument.add(c);
                    }
                }
                for (Class clazz : optimizedClassesToInstrument) {
                    retransformationLock.lock();
                    if (!classesBeingRetransformed.containsKey(classNameForest.getIDIfExists(clazz.getName()))) {
                        classesBeingRetransformed.put(classNameForest.getIDIfExists(clazz.getName()), new HashSet());
                    }
                    ((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).add(clazz.getClassLoader());
                    retransformationLock.unlock();
                    if (transformer.shouldRetransform(clazz)) {
                        instrumentationDelegate.retransformClasses(kModule, clazz);
                    } else {
                        logger.debug(kModule, "Class " + clazz.getName() + " is being skipped");
                    }
                    retransformationLock.lock();
                    ((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).remove(clazz.getClassLoader());
                    if (((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).size() == 0) {
                        classesBeingRetransformed.remove(classNameForest.getIDIfExists(clazz.getName()));
                    }
                    retransformationLock.unlock();
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "Retransfroming sub tree for class " + this.rootClassName + " in classloader " + this.rootClassLoader.getClass().getName() + " failed.", t);
            }
        }
    }
}

