/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.connector;

import com.wily.introscope.api.autoprobe.AutoProbeCreationFailedException;
import com.wily.introscope.api.autoprobe.IntroscopeAutoProbe;
import com.wily.introscope.api.autoprobe.IntroscopeAutoProbeFactory;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorException;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorJVMUtilities;
import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.zip.ZipFile;

public final class AutoProbeConnector {
    private static boolean sNeverAttemptedLoad = true;
    private static IntroscopeAutoProbe sAutoProbe;
    private static ClassLoader instanceLoader;
    private static final String kRelaxedJVMCheckClass = "com.wily.introscope.autoprobe.connector.RelaxedJVMCheckMarker";
    private static final String kWarnTag = "[WARN]";
    private static final String kErrorTag = "[ERROR]";

    private AutoProbeConnector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean versionCheck(String connectorJVMIdentity, long connectorClassLoaderCheckSum) {
        boolean result = true;
        boolean isRelaxed = AutoProbeConnector.isRelaxedVersionCheck();
        String outputSeverityTag = null;
        boolean nastyError = false;
        outputSeverityTag = isRelaxed ? kWarnTag : kErrorTag;
        try {
            String jvmDirectoryName = System.getProperty("java.home");
            try (ZipFile runtimeJar = AutoProbeConnectorJVMUtilities.findRuntimeJar(new File(jvmDirectoryName));){
                String actualJVMIdentity = AutoProbeConnectorJVMUtilities.loadJVMIdentity(runtimeJar);
                long actualClassLoaderCheckSum = AutoProbeConnectorJVMUtilities.generateCheckSum(runtimeJar);
                if (!connectorJVMIdentity.equals(actualJVMIdentity)) {
                    System.err.println("[WARN] Attempting to run an AutoProbe Connector with an different JVM (expected version = " + connectorJVMIdentity + ", actual version = " + actualJVMIdentity + ")");
                    System.err.println("[WARN] To avoid this warning, re-generate the AutoProbe Connector with the current JVM.");
                }
                if (connectorClassLoaderCheckSum != actualClassLoaderCheckSum) {
                    System.err.println(outputSeverityTag + " Attempting to run an AutoProbe Connector with an incompatible JVM (expected checksum = " + connectorClassLoaderCheckSum + ", actual checksum = " + actualClassLoaderCheckSum + ")");
                    System.err.println(outputSeverityTag + " To fix, re-generate the AutoProbe Connector with the current JVM.");
                    nastyError = true;
                }
            }
        }
        catch (AutoProbeConnectorException apce) {
            System.err.println(outputSeverityTag + " Unable to determine the current JVM identity: " + apce.getMessage());
            System.err.println(outputSeverityTag + " AutoProbe will not run.");
            nastyError = true;
            result = false;
        }
        catch (IOException ioe) {
            System.err.println(outputSeverityTag + " Unable to determine the current JVM identity: " + ioe.getMessage());
            ioe.printStackTrace(System.err);
            System.err.println(outputSeverityTag + " AutoProbe will not run.");
            nastyError = true;
            result = false;
        }
        if (nastyError && !isRelaxed) {
            System.exit(1);
        }
        return result;
    }

    private static boolean isRelaxedVersionCheck() {
        try {
            ClassLoader cl = instanceLoader;
            cl.loadClass(kRelaxedJVMCheckClass);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static IntroscopeAutoProbe internalLoadAutoProbeAdapter(String jvmIdentity, long classLoaderCheckSum) {
        try {
            return IntroscopeAutoProbeFactory.createIntroscopeAutoProbe(null);
        }
        catch (AutoProbeCreationFailedException apcfe) {
            System.err.println("[ERROR] Unable to start AutoProbe: " + apcfe.getMessage());
            apcfe.printStackTrace(System.err);
            return null;
        }
    }

    private static IntroscopeAutoProbe loadAutoProbeAdapter(String jvmIdentity, long classLoaderCheckSum) {
        IntroscopeAutoProbe result = null;
        try {
            if (AutoProbeConnector.versionCheck(jvmIdentity, classLoaderCheckSum)) {
                result = AutoProbeConnector.internalLoadAutoProbeAdapter(jvmIdentity, classLoaderCheckSum);
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            System.err.println("[ERROR] Unable to locate AutoProbe.  Please make sure Agent.jar is on the bootstrap classpath: " + ncdfe.toString());
        }
        return result;
    }

    private static synchronized IntroscopeAutoProbe getAutoProbeAdapter(String jvmIdentity, long classLoaderCheckSum) {
        if (sNeverAttemptedLoad) {
            sNeverAttemptedLoad = false;
            sAutoProbe = AutoProbeConnector.loadAutoProbeAdapter(jvmIdentity, classLoaderCheckSum);
        }
        return sAutoProbe;
    }

    public static byte[] addProbes(String jvmIdentity, long classLoaderCheckSum, ClassLoader classLoader, String className, byte[] classBytes, int offset, int length, ProtectionDomain protectionDomain) {
        try {
            IntroscopeAutoProbe autoProbe;
            if (classBytes[0] != -54 || classBytes[1] != -2 || classBytes[2] != -70 || classBytes[3] != -66) {
                return null;
            }
            if (classBytes != null && offset >= 0 && length >= 0 && offset + length <= classBytes.length && (autoProbe = AutoProbeConnector.getAutoProbeAdapter(jvmIdentity, classLoaderCheckSum)) != null) {
                byte[] original = classBytes;
                if (offset != 0 || length != classBytes.length) {
                    original = new byte[length];
                    System.arraycopy(classBytes, offset, original, 0, length);
                }
                return autoProbe.addProbes(classLoader, className, null, original, protectionDomain);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        instanceLoader = Thread.currentThread().getContextClassLoader();
    }
}

