/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.connector;

import com.wily.introscope.autoprobe.connector.AutoProbeConnectorException;
import com.wily.introscope.autoprobe.connector.KAutoProbeConnectorConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class AutoProbeConnectorJVMUtilities {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    private AutoProbeConnectorJVMUtilities() {
    }

    private static String[] getPrependPaths() {
        StringTokenizer st;
        int nTokens;
        String[] result = null;
        String prependProp = System.getProperty("com.wily.autoprobe.prependToJVMRuntimePath");
        if (prependProp != null && (nTokens = (st = new StringTokenizer(prependProp, File.pathSeparator)).countTokens()) > 0) {
            result = new String[nTokens];
            int index = 0;
            while (st.hasMoreTokens()) {
                result[index++] = st.nextToken();
            }
        }
        return result;
    }

    public static final ZipFile findRuntimeJar(File jvmDirectory) throws AutoProbeConnectorException, IOException {
        ZipFile result;
        File runtimeFile;
        int i;
        String[] prependPaths = AutoProbeConnectorJVMUtilities.getPrependPaths();
        if (prependPaths != null) {
            for (i = 0; i < prependPaths.length; ++i) {
                runtimeFile = new File(prependPaths[i]);
                if (!runtimeFile.exists()) continue;
                result = null;
                if (AutoProbeConnectorJVMUtilities.isJarFile(runtimeFile)) {
                    result = new JarFile(runtimeFile);
                } else if (AutoProbeConnectorJVMUtilities.isZipFile(runtimeFile)) {
                    result = new ZipFile(runtimeFile);
                } else {
                    throw new AutoProbeConnectorException("Unable to locate the Java runtime classes to build the connector.");
                }
                try {
                    InputStream is = AutoProbeConnectorJVMUtilities.loadClassLoader(result);
                    is.close();
                }
                catch (AutoProbeConnectorException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                return result;
            }
        }
        for (i = 0; i < KAutoProbeConnectorConstants.kRuntimeRelativeFilenameOptions.length; ++i) {
            runtimeFile = new File(jvmDirectory, KAutoProbeConnectorConstants.kRuntimeRelativeFilenameOptions[i]);
            if (!runtimeFile.exists()) continue;
            result = null;
            if (AutoProbeConnectorJVMUtilities.isJarFile(runtimeFile)) {
                result = new JarFile(runtimeFile);
            } else if (AutoProbeConnectorJVMUtilities.isZipFile(runtimeFile)) {
                result = new ZipFile(runtimeFile);
            } else {
                throw new AutoProbeConnectorException("Unable to locate the Java runtime classes to build the connector.");
            }
            try {
                InputStream in = AutoProbeConnectorJVMUtilities.loadClassLoader(result);
                in.close();
            }
            catch (AutoProbeConnectorException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            return result;
        }
        throw new AutoProbeConnectorException("Unable to locate the Java runtime classes to build the connector.");
    }

    private static boolean isZipFile(File file) throws IOException {
        String path;
        if (file != null && (path = file.getCanonicalPath()) != null) {
            return (path = path.trim()).endsWith(".zip") || path.endsWith(".ZIP");
        }
        return false;
    }

    private static boolean isJarFile(File file) throws IOException {
        String path;
        if (file != null && (path = file.getCanonicalPath()) != null) {
            return (path = path.trim()).endsWith(".jar") || path.endsWith(".JAR");
        }
        return false;
    }

    public static String loadJVMIdentity(ZipFile runtimeZip) throws AutoProbeConnectorException, IOException {
        String identity = "IBM_J9_Hybrid";
        if (runtimeZip instanceof JarFile) {
            JarFile runtimeJar = (JarFile)runtimeZip;
            Manifest manifest = runtimeJar.getManifest();
            if (manifest != null) {
                identity = AutoProbeConnectorJVMUtilities.getMainAttributeFromManifest(manifest, "Created-By");
            }
        } else {
            Manifest manifest = AutoProbeConnectorJVMUtilities.getManifestFromZIP(runtimeZip);
            identity = manifest == null ? "IBM_J9_Hybrid" : AutoProbeConnectorJVMUtilities.getMainAttributeFromManifest(manifest, "Created-By");
        }
        return identity;
    }

    public static String getMainAttributeFromManifest(Manifest manifest, String attributeName) throws AutoProbeConnectorException {
        String identity = "NOT PROVIDED IN THE JVM RUNTIME JAR";
        if (manifest == null) {
            return identity;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return identity;
        }
        identity = attributes.getValue("Created-By");
        if (identity == null || identity.length() == 0) {
            identity = "NOT PROVIDED IN THE JVM RUNTIME JAR";
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifestFromZIP(ZipFile zipFile) throws IOException {
        ZipEntry zipEntry;
        Manifest manifest = null;
        if (zipFile != null && (zipEntry = zipFile.getEntry(MANIFEST_PATH)) != null) {
            try (InputStream in = zipFile.getInputStream(zipEntry);){
                manifest = new Manifest(in);
            }
        }
        return manifest;
    }

    public static InputStream loadClassLoader(ZipFile runtimeJar) throws AutoProbeConnectorException, IOException {
        ZipEntry entry = runtimeJar.getEntry("java/lang/ClassLoader.class");
        if (entry == null) {
            throw new AutoProbeConnectorException("Unable to locate the java.lang.ClassLoader classfile.");
        }
        return runtimeJar.getInputStream(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long generateCheckSum(ZipFile runtimeJar) throws AutoProbeConnectorException, IOException {
        try (InputStream classLoader = AutoProbeConnectorJVMUtilities.loadClassLoader(runtimeJar);){
            CRC32 crc = new CRC32();
            long l = AutoProbeConnectorJVMUtilities.computeCheckSum(crc, classLoader);
            return l;
        }
    }

    private static long computeCheckSum(CRC32 crc, InputStream input) throws IOException {
        int size;
        byte[] temp = new byte[1024];
        while ((size = input.read(temp)) > 0) {
            crc.update(temp, 0, size);
        }
        return crc.getValue();
    }
}

