/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.beans.application;

import com.wily.introscope.spec.metric.AgentName;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class AgentApplication
implements IConstructorExternalizable {
    private final AgentName fAgent;
    private final String fApplicationName;
    private final String fRootServletContextPath;
    private String fWebXml;
    private HashMap fProperties;

    public AgentApplication(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fAgent = (AgentName)in.readObject();
        this.fApplicationName = in.readUTF();
        this.fRootServletContextPath = in.readUTF();
        this.fWebXml = in.readUTF();
        this.fProperties = (HashMap)in.readObject();
    }

    public AgentApplication(AgentName agent, String applicationName, String path, String xml) {
        this.fAgent = agent;
        this.fApplicationName = applicationName;
        this.fRootServletContextPath = path;
        this.fWebXml = xml;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgentApplication) {
            AgentApplication other = (AgentApplication)obj;
            return this.fAgent.equals(other.fAgent) && this.fApplicationName.equals(other.fApplicationName);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (String.valueOf(this.fAgent.toString()) + this.fApplicationName).hashCode();
    }

    public String toString() {
        return String.valueOf(this.fAgent.getAgentName()) + " - " + this.fApplicationName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fAgent);
        out.writeUTF(this.fApplicationName);
        out.writeUTF(this.fRootServletContextPath);
        out.writeUTF(this.fWebXml);
        out.writeObject(this.fProperties);
    }

    public AgentName getAgent() {
        return this.fAgent;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }

    public HashMap getProperties() {
        return this.fProperties;
    }

    public String getRootServletContextPath() {
        return this.fRootServletContextPath;
    }

    public String getWebXml() {
        return this.fWebXml;
    }
}

