/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.ACombiningGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public abstract class ALongCombiningGatherer
extends ACombiningGatherer {
    protected ALongCombiningGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    @Override
    protected ATimeslicedValue doCombiningHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getDataPointCount(), false, this.getLongValue(), this.getLongMinimum(), this.getLongMaximum());
    }

    public abstract long getLongValue();

    public abstract long getLongMinimum();

    public abstract long getLongMaximum();

    protected abstract void directSetLongMinimum(long var1);

    protected abstract void directSetLongMaximum(long var1);

    @Override
    protected final void doAcceptAggregateTimeslicedValue(IMetricDataValue newAggregate) throws IncompatibleTypesException {
        LongTimeslicedValue typedAggregate;
        try {
            typedAggregate = (LongTimeslicedValue)newAggregate;
        }
        catch (ClassCastException cce) {
            throw new IncompatibleTypesException("Failed to cast the object: " + newAggregate + " to a LongTimeslicedValue", cce);
        }
        this.doAcceptAggregateLongTimeslicedValue(typedAggregate);
    }

    protected abstract void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue var1);

    protected void syncSinglePointBounds(long value) {
        if (this.isFirstDataPoint()) {
            this.directSetLongMaximum(value);
            this.directSetLongMinimum(value);
        } else {
            if (value > this.getLongMaximum()) {
                this.directSetLongMaximum(value);
            }
            if (value < this.getLongMinimum()) {
                this.directSetLongMinimum(value);
            }
        }
    }

    protected void syncAggregateBounds(LongTimeslicedValue newAggregate) {
        if (this.isFirstDataPoint()) {
            this.directSetLongMaximum(newAggregate.getMaximum());
            this.directSetLongMinimum(newAggregate.getMinimum());
        } else {
            if (newAggregate.getMaximum() > this.getLongMaximum()) {
                this.directSetLongMaximum(newAggregate.getMaximum());
            }
            if (newAggregate.getMinimum() < this.getLongMinimum()) {
                this.directSetLongMinimum(newAggregate.getMinimum());
            }
        }
    }
}

