/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.ACombiningGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class CumulativeCounterGatherer
extends ACombiningGatherer {
    private boolean isFirstCall = true;
    private long durationStartCumulativeValue;
    private long currentCumulativeValue;

    public CumulativeCounterGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
        this.durationStartCumulativeValue = this.currentCumulativeValue;
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
        this.durationStartCumulativeValue = 0L;
        this.isFirstCall = true;
    }

    @Override
    protected ATimeslicedValue doCombiningHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getDataPointCount(), false, this.getDataPointCount(), this.getDataPointCount(), this.getDataPointCount());
    }

    @Override
    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        this.addToDataPointCount(value.getDataPointCount());
    }

    public synchronized void addOnlyDelta(long currentValue) {
        if (this.isFirstCall) {
            this.durationStartCumulativeValue = currentValue;
            this.isFirstCall = false;
        } else if (this.durationStartCumulativeValue > currentValue) {
            this.durationStartCumulativeValue = 0L;
        } else {
            this.setDataPointCount(currentValue - this.durationStartCumulativeValue);
            this.newDataPointsReceived();
            this.noteDataIsPresent();
        }
        this.currentCumulativeValue = currentValue;
    }
}

