/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import com.wily.introscope.threaddump.common.ThreadDumpHelper;
import com.wily.introscope.threaddump.common.WilyThreadInfo;
import java.io.Externalizable;

public class WilyThreadInfoExtended
extends WilyThreadInfo
implements Externalizable {
    private String fCorrelationId;
    private String fComponent;
    private long fTimestamp;

    public WilyThreadInfoExtended() {
    }

    public WilyThreadInfoExtended(WilyThreadInfo info) {
        super(info.getThreadID(), info.getThreadName(), info.getBlockedTime(), info.getBlockedCount(), info.getWaitedTime(), info.getWaitedCount(), info.getLockName(), info.getLockOwnerName(), info.getLockOwnerID(), info.isInNative(), info.isSuspended(), info.getThreadState(), info.getStackTrace(), info.isDeadlocked());
    }

    public WilyThreadInfoExtended(long threadID, String threadName, long blockedTime, long blockedCount, long waitedTime, long waitedCount, String lockName, String lockOwnerName, long lockOwnerID, boolean inNative, boolean suspended, String threadState, StackTraceElement[] stackTrace, boolean isDeadlocked) {
        super(threadID, threadName, blockedTime, blockedCount, waitedTime, waitedCount, lockName, lockOwnerName, lockOwnerID, inNative, suspended, threadState, stackTrace, isDeadlocked);
    }

    public WilyThreadInfoExtended(Thread t, StackTraceElement[] stack) {
        super(ThreadDumpHelper.getThreadState(t.getState()), stack);
    }

    public void enforceStackTraceLength(int maxStackLength) {
        int stackLength = this.getStackLen();
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackLength <= maxStackLength) {
            return;
        }
        int framesToRemove = stackLength - maxStackLength + 1;
        int firstFrameToRemove = (stackLength - framesToRemove) / 2;
        StackTraceElement[] newStack = new StackTraceElement[maxStackLength];
        int i = 0;
        while (i < firstFrameToRemove) {
            newStack[i] = stackTrace[i];
            ++i;
        }
        newStack[firstFrameToRemove] = new StackTraceElement("Ommitted", "frames", "count", framesToRemove);
        i = firstFrameToRemove + 1;
        while (i < maxStackLength) {
            newStack[i] = stackTrace[i + framesToRemove - 1];
            ++i;
        }
        this.setStackTrace(newStack);
    }

    public String getCorrelationId() {
        return this.fCorrelationId;
    }

    public void setCorrelationId(String correlationId) {
        this.fCorrelationId = correlationId;
    }

    public String getComponent() {
        return this.fComponent;
    }

    public void setComponent(String component) {
        this.fComponent = component;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.fTimestamp = timestamp;
    }
}

