/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.tree;

import com.wily.isengard.util.tree.DirectoryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.DirectoryPathAndEntry;
import com.wily.isengard.util.tree.DirectoryPathTokenizer;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.isengard.util.tree.NodeAlreadyExistsException;
import com.wily.wilyassert.Assertion;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DirectoryTreeNode {
    private Map<String, DirectoryTreeNode> fChildren;
    private DirectoryTreeNode fParent;
    private String fName;
    private DirectoryEntry fEntry;

    public DirectoryTreeNode(DirectoryTreeNode parent, String name, DirectoryEntry entry) {
        this.fParent = parent;
        this.fName = name;
        this.fEntry = entry;
        this.fChildren = new ConcurrentHashMap<String, DirectoryTreeNode>();
    }

    public String getName() {
        return this.fName;
    }

    public String getPathString() {
        if (this.fParent == null) {
            return "";
        }
        return String.valueOf(this.fParent.getPathString()) + "/" + this.fName;
    }

    public DirectoryPath getPath() {
        return new DirectoryPath(this.getPathString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(DirectoryTreeNode node) throws NodeAlreadyExistsException {
        if (node == null) {
            return;
        }
        String nodeName = node.getName();
        Map<String, DirectoryTreeNode> map = this.fChildren;
        synchronized (map) {
            if (this.getChildNode(nodeName) != null) {
                throw new NodeAlreadyExistsException();
            }
            if (nodeName != null) {
                this.fChildren.put(nodeName, node);
            }
        }
    }

    private DirectoryTreeNode getChildNode(String nodeName) {
        return nodeName != null ? this.fChildren.get(nodeName) : null;
    }

    public DirectoryTreeIterator getSubDirectoryIterator(DirectoryPathTokenizer tokenizer) throws InvalidPathException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.getSubDirectoryIterator(tokenizer);
        }
        return this.shallowIterator();
    }

    private void removePathFromParent() {
        if (this.fEntry == null && this.fChildren.isEmpty() && this.fParent != null) {
            if (this.fName != null) {
                this.fParent.fChildren.remove(this.fName);
            }
            this.fParent.removePathFromParent();
        }
    }

    public boolean hasEntry(DirectoryPathTokenizer tokenizer) {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                return false;
            }
            return node.hasEntry(tokenizer);
        }
        return this.fEntry != null;
    }

    public DirectoryEntry getEntry(DirectoryPathTokenizer tokenizer) throws InvalidPathException, EntryNotFoundException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.getEntry(tokenizer);
        }
        if (this.fEntry == null) {
            throw new EntryNotFoundException(this.getPathString());
        }
        return this.fEntry;
    }

    public DirectoryEntry deleteEntry(DirectoryPathTokenizer tokenizer) throws InvalidPathException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.deleteEntry(tokenizer);
        }
        DirectoryEntry entry = this.fEntry;
        this.fEntry = null;
        this.removePathFromParent();
        return entry;
    }

    public void addIfNotExists(DirectoryPathTokenizer tokenizer, DirectoryEntry entry) throws EntryAlreadyExistsException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                node = new DirectoryTreeNode(this, nodeName, null);
                try {
                    this.addChild(node);
                }
                catch (NodeAlreadyExistsException nodeAlreadyExistsException) {}
            }
            node.addIfNotExists(tokenizer, entry);
        } else {
            if (this.fEntry != null) {
                String path = this.getPathString();
                throw new EntryAlreadyExistsException(path, this.fEntry);
            }
            this.fEntry = entry;
        }
    }

    public DirectoryTreeIterator iterator() {
        return new DirectoryTreeIterator(this, true);
    }

    public Collection<DirectoryTreeNode> values() {
        return this.fChildren.values();
    }

    public DirectoryTreeIterator shallowIterator() {
        return new DirectoryTreeIterator(this, false);
    }

    public void clear() {
        this.fChildren.clear();
    }

    public static class DirectoryTreeIterator
    implements Iterator<DirectoryPathAndEntry> {
        private Deque<Iterator<DirectoryTreeNode>> fIteratorStack;
        private boolean fNextIsPositioned;
        private final boolean fGoDeep;
        private DirectoryPathAndEntry fNextObject;

        private DirectoryTreeIterator(DirectoryTreeNode currentNode, boolean goDeep) {
            this.fGoDeep = goDeep;
            this.fNextIsPositioned = false;
            this.fNextObject = null;
            this.fIteratorStack = new ArrayDeque<Iterator<DirectoryTreeNode>>();
            this.fIteratorStack.push(currentNode.fChildren.values().iterator());
        }

        private void positionNext() {
            if (this.fNextIsPositioned) {
                return;
            }
            if (this.fIteratorStack.isEmpty()) {
                return;
            }
            Iterator<DirectoryTreeNode> i = this.fIteratorStack.pop();
            if (!i.hasNext()) {
                this.positionNext();
                return;
            }
            DirectoryTreeNode node = i.next();
            if (this.fGoDeep && !node.fChildren.isEmpty()) {
                this.fIteratorStack.push(node.fChildren.values().iterator());
            }
            this.fIteratorStack.push(i);
            this.fNextObject = new DirectoryPathAndEntry(node.getPath(), node.fEntry);
            this.fNextIsPositioned = true;
        }

        @Override
        public boolean hasNext() {
            this.positionNext();
            return this.fNextObject != null;
        }

        @Override
        public DirectoryPathAndEntry next() {
            this.positionNext();
            DirectoryPathAndEntry result = this.fNextObject;
            this.fNextIsPositioned = false;
            this.fNextObject = null;
            return result;
        }

        @Override
        public void remove() {
            Assertion.wilyAssert(false, "Unsupported");
        }
    }
}

