/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ObserverAction;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashSet;
import java.util.Set;

public class ObserverTracker {
    private IModuleFeedbackChannel fFeedback;
    private Set fObservers;

    public ObserverTracker(IModuleFeedbackChannel feedback) {
        this(feedback, new HashSet());
    }

    public ObserverTracker(IModuleFeedbackChannel feedback, Set observerSet) {
        this.fFeedback = feedback;
        this.fObservers = observerSet;
    }

    public synchronized void addObserver(Object newObserver) {
        this.fObservers.add(newObserver);
    }

    public synchronized void removeObserver(Object newObserver) {
        this.fObservers.remove(newObserver);
    }

    public synchronized void forEachObserverDo(ObserverAction action, Object parameter) {
        Object[] observers = this.fObservers.toArray();
        int x = 0;
        while (x < observers.length) {
            try {
                action.doAction(observers[x], parameter);
            }
            catch (Exception e) {
                IModuleFeedbackChannel feedbackChannel = this.getModuleFeedback();
                if (feedbackChannel.isVerboseEnabled()) {
                    feedbackChannel.error("ObserverAction.doAction threw: " + action.toString() + " " + observers[x].toString());
                }
                feedbackChannel.verbose(e);
            }
            ++x;
        }
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }
}

