/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

public class WilyMath {
    private static final double kNaturalLogOfTen = Math.log(10.0);

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < values.length) {
            max = values[i] > max ? values[i] : max;
            ++i;
        }
        return max;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < values.length) {
            min = values[i] < min ? values[i] : min;
            ++i;
        }
        return min;
    }

    public static double roundUp(double value, int sigFigs) {
        return WilyMath.round(value, sigFigs, true);
    }

    public static double roundDown(double value, int sigFigs) {
        return WilyMath.round(value, sigFigs, false);
    }

    public static double round(double value, int sigFigs, boolean up) {
        if (value == 0.0) {
            return 0.0;
        }
        int exponent = (int)Math.floor(WilyMath.log10(Math.abs(value))) - sigFigs + 1;
        double multiplier = Math.pow(10.0, exponent);
        double base = value / multiplier;
        base = up ? (double)((int)Math.ceil(base)) : (double)((int)Math.floor(base));
        double result = base * multiplier;
        return result;
    }

    public static double log10(double value) {
        return Math.log(value) / kNaturalLogOfTen;
    }

    public static double roundToDecimal(double value, int decimalPoints) {
        double multiplier = Math.pow(10.0, decimalPoints);
        if (value * multiplier >= 9.223372036854776E18) {
            multiplier = 1.0;
        }
        value *= multiplier;
        value = Math.round(value);
        return value / multiplier;
    }

    public static int min(int int1, int int2) {
        return int1 < int2 ? int1 : int2;
    }

    public static int max(int int1, int int2) {
        return int1 > int2 ? int1 : int2;
    }

    public static int gcd(int a, int b) {
        return a > b ? WilyMath.euclidGCD(a, b) : WilyMath.euclidGCD(b, a);
    }

    private static int euclidGCD(int a, int b) {
        int remainder = a % b;
        return remainder == 0 ? b : WilyMath.euclidGCD(b, remainder);
    }

    public static int overflowExp(int base, int power) {
        int fac = 1;
        while (power != 0) {
            fac *= (power & 1) == 1 ? base : 1;
            base *= base;
            power /= 2;
        }
        return fac;
    }
}

