/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile;

import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;

public final class FullyQualifiedMethodName {
    private final IClassName fClassName;
    private final IMethodName fMethodName;

    public FullyQualifiedMethodName(IClassName className, IMethodName methodName) {
        this.fClassName = className;
        this.fMethodName = methodName;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public IMethodName getMethodName() {
        return this.fMethodName;
    }

    public String getFullyQualifiedNameString() {
        return String.valueOf(this.fClassName.getContainerAndPackageAndNameString()) + "." + this.fMethodName.getNameAndSignatureString();
    }

    public String toString() {
        return this.getFullyQualifiedNameString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FullyQualifiedMethodName) {
            FullyQualifiedMethodName name = (FullyQualifiedMethodName)obj;
            return this.getClassName().equals(name.getClassName()) && this.getMethodName().equals(name.getMethodName());
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = HashCodeUtils.accumulateHashCode(hash, this.getClassName().hashCode());
        hash = HashCodeUtils.accumulateHashCode(hash, this.getMethodName().hashCode());
        return hash;
    }
}

