/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.classfile.InvalidPackageNameException;
import com.wily.util.classfile.java.ClassFileValidationUtilities;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class PackageName
implements IPackageName {
    public static final String kDefaultPackageSeparator = "/";
    public static final char kDefaultPackageSeparatorChar = '/';
    public static final char kOptionalPackageSeparatorChar = '.';
    private static final PackageName kDefaultPackage = new PackageName();
    private final String[] fPackages;
    private String name;

    private PackageName() {
        this.fPackages = new String[0];
    }

    private PackageName(String name, String[] packages) {
        this.name = name;
        this.fPackages = packages;
    }

    @Override
    public String getNameString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.buildString('/');
        }
        return this.name;
    }

    @Override
    public boolean isDefaultPackage() {
        return this == kDefaultPackage;
    }

    public int getPackageCount() {
        return this.fPackages.length;
    }

    public String getPackageSegment(int index) {
        return this.fPackages[index];
    }

    public String getDotSeparatedName() {
        return this.buildString('.');
    }

    public String toString() {
        return this.buildString('/');
    }

    private String buildString(char separator) {
        if (this.fPackages.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.fPackages.length) {
            buffer.append(this.fPackages[i]);
            if (i < this.fPackages.length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageName) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static PackageName getPackageName(String packageName) throws InvalidPackageNameException {
        if (packageName == null || packageName.length() == 0) {
            return kDefaultPackage;
        }
        String normalizedName = packageName.replace('.', '/');
        return PackageName.parseSlashSeparatedPackageName(normalizedName, true);
    }

    public static PackageName getNonDefaultPackageName(String packageName) throws InvalidPackageNameException {
        if (packageName == null || packageName.length() == 0) {
            throw new InvalidPackageNameException(new FormattedLocalizableMessage("Class_File_Invalid_Package_Name", packageName), packageName);
        }
        String normalizedName = packageName.replace('.', '/');
        return PackageName.parseSlashSeparatedPackageName(normalizedName, false);
    }

    private static PackageName parseSlashSeparatedPackageName(String name, boolean allowDefaultPackage) throws InvalidPackageNameException {
        try {
            String[] packages = PackageName.separatePackages(name);
            if (packages == null || packages.length == 0) {
                if (allowDefaultPackage) {
                    return kDefaultPackage;
                }
                throw new InvalidPackageNameException(new FormattedLocalizableMessage("Class_File_Invalid_Package_Name", name), name);
            }
            return new PackageName(name, packages);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            throw new InvalidPackageNameException(new FormattedLocalizableMessage("Class_File_Invalid_Package_Name", name), name);
        }
    }

    public static String[] separatePackages(String name) throws InvalidIdentifierException {
        ArrayList<String> results = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(name, kDefaultPackageSeparator, true);
        boolean lastWasSeparator = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(kDefaultPackageSeparator)) {
                if (lastWasSeparator) {
                    throw new InvalidIdentifierException(new SimpleLocalizableMessage("Class_File_Empty_Identifier"), name);
                }
                lastWasSeparator = true;
                continue;
            }
            ClassFileValidationUtilities.validateSimpleJavaIdentifier(token);
            results.add(token);
            lastWasSeparator = false;
        }
        if (lastWasSeparator) {
            throw new InvalidIdentifierException(new SimpleLocalizableMessage("Class_File_Empty_Identifier"), name);
        }
        return results.toArray(new String[results.size()]);
    }
}

