/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend;

import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import java.util.Enumeration;
import java.util.Properties;

public abstract class PropertyConfigurableBackend
implements IFeedbackBackend {
    private static final String defaultLevelPropertyPrefix = "introscope.log.level.";
    protected static String levelPropertyPrefix = "introscope.log.level.";
    private static final String defaultAppenderPropertyPrefix = "introscope.log.destination.";
    protected static String appenderPropertyPrefix = "introscope.log.destination.";
    public static final String rootLevelName = "root";
    protected SeverityLevel rootLevel = SeverityLevel.INFO;

    public static void setCustomLevelPropertyPrefix(String prefix) {
        levelPropertyPrefix = prefix;
    }

    public static String getCustomLevelPropertyPrefix(String prefix) {
        return levelPropertyPrefix;
    }

    public static void setCustomAppenderPropertyPrefix(String prefix) {
        appenderPropertyPrefix = prefix;
    }

    public static String getCustomAppenderPropertyPrefix(String prefix) {
        return appenderPropertyPrefix;
    }

    protected PropertyConfigurableBackend() {
    }

    @Override
    public void setGlobalDefaults(String defaultOutputTarget) {
    }

    @Override
    public void setGlobalConfiguration(Properties props) {
        this.configureFromProperties(props);
    }

    private void setAppenders(String logger, String appenders) {
    }

    @Override
    public void configureFromProperties(Properties properties) {
        String appenderPropertyKey;
        String[] appenders;
        int n;
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String[] appenders2;
            String loggerName;
            String attribute = (String)e.nextElement();
            if (attribute.startsWith(levelPropertyPrefix)) {
                loggerName = attribute.substring(levelPropertyPrefix.length()).trim();
                String levelName = properties.getProperty(attribute).trim().toUpperCase();
                SeverityLevel severityLevel = SeverityLevel.getLevelByName(levelName);
                if (loggerName.equals(rootLevelName)) {
                    this.setRootLevel(severityLevel);
                } else {
                    this.setLevel(this.getLoggerByName(loggerName), severityLevel);
                }
            }
            if (!attribute.startsWith(appenderPropertyPrefix)) continue;
            loggerName = attribute.substring(appenderPropertyPrefix.length()).trim();
            String[] stringArray = appenders2 = ((IndexedProperties)properties).safeGetSeparatedProperty(attribute, ",");
            int n2 = appenders2.length;
            n = 0;
            while (n < n2) {
                String appender = stringArray[n];
                String appenderName = appender.trim().toUpperCase();
                if (loggerName.equals(rootLevelName)) {
                    this.setRootAppender(appenderName);
                } else {
                    this.setAppender(this.getLoggerByName(loggerName), appenderName);
                }
                ++n;
            }
        }
        if (appenderPropertyPrefix.endsWith(".") && (appenders = ((IndexedProperties)properties).safeGetSeparatedProperty(appenderPropertyKey = appenderPropertyPrefix.substring(0, appenderPropertyPrefix.length() - 1), ",")) != null) {
            String[] stringArray = appenders;
            n = appenders.length;
            int n3 = 0;
            while (n3 < n) {
                String appender = stringArray[n3];
                String appenderName = appender.trim().toUpperCase();
                this.setRootAppender(appenderName);
                ++n3;
            }
        }
    }

    @Override
    public boolean containsLoggingConfiguration(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (attribute.indexOf(levelPropertyPrefix) >= 0) {
                return true;
            }
            if (attribute.indexOf(appenderPropertyPrefix) < 0) continue;
            return true;
        }
        return false;
    }

    public abstract void setAppender(Object var1, String var2);

    public abstract void setRootAppender(String var1);

    @Override
    public void setRootLevel(SeverityLevel level) {
        this.rootLevel = level;
    }

    @Override
    public boolean isRootEnabledFor(SeverityLevel level) {
        return !this.rootLevel.isLessThan(level);
    }

    @Override
    public IConfigurationListener createConfigurationListener(IResource configResource) {
        return new IConfigurationListener(){

            @Override
            public void onChange(IndexedProperties newProps) {
                PropertyConfigurableBackend.this.configureFromProperties(newProps);
            }
        };
    }
}

