/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.Calculator;
import com.wily.introscope.agent.metric.calculator.CalculatorService;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CalculatorSet {
    private String name;
    private boolean debug;
    private transient String loadedFromFile = null;
    private List<Calculator> calculators;
    private transient CalculatorService service;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalculatorSet other = (CalculatorSet)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public CalculatorSet(String name, Calculator[] calculators) {
        this.name = name;
        this.calculators = Arrays.asList(calculators);
    }

    public CalculatorSet() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Calculator> getCalculators() {
        return this.calculators;
    }

    public void setCalculators(List<Calculator> calculators) {
        this.calculators = calculators;
    }

    public CalculatorSet setService(CalculatorService service) {
        this.service = service;
        for (Calculator calc : this.calculators) {
            calc.setService(service);
        }
        this.setDebug(this.debug);
        return this;
    }

    public CalculatorSet calculate(Map<String, IMetricDataValue> inputMetrics) {
        long startTime = 0L;
        long startOutputMetricCount = 0L;
        boolean doSustainabilityMetrics = this.service.getSustainability().isEnabled();
        if (doSustainabilityMetrics) {
            startTime = System.currentTimeMillis();
            startOutputMetricCount = this.service.getOutputMetrics().size();
        }
        for (Calculator calc : this.calculators) {
            calc.calculate(inputMetrics);
        }
        if (doSustainabilityMetrics) {
            long endTime = System.currentTimeMillis();
            long endOutputMetricCount = this.service.getOutputMetrics().size();
            this.service.getSustainability().reportCalculatorSetMetrics(this.name, (int)(endTime - startTime), this.calculators.size(), (int)(endOutputMetricCount - startOutputMetricCount));
        }
        return this;
    }

    public void setLoadedFromFile(String file) {
        this.loadedFromFile = file;
    }

    public String isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
        for (Calculator calc : this.calculators) {
            calc.setDebug(this.debug);
        }
    }
}

