/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class MetricPatternUtils {
    public static Object[] parseMetricPattern(String pattern) {
        int i;
        if (pattern == null) {
            return null;
        }
        int pos = 0;
        ArrayList<Object> result = new ArrayList<Object>();
        while ((i = pattern.indexOf(123, pos)) >= 0) {
            int e;
            if (i > pos) {
                result.add(pattern.substring(pos, i));
            }
            if ((e = pattern.indexOf(125, i + 1)) < 0) {
                return null;
            }
            String var = pattern.substring(i + 1, e);
            try {
                result.add(Integer.parseInt(var));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            pos = e + 1;
        }
        result.add(pattern.substring(pos));
        return result.toArray();
    }

    public static String resolveMetric(Object[] tokens, String[] vars) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            Object token = tokens[i];
            if (token instanceof String) {
                sb.append((String)token);
                continue;
            }
            if (!(token instanceof Integer)) continue;
            sb.append(vars[(Integer)token]);
        }
        return sb.toString();
    }

    public static String convertPatternToRegex(String pattern) {
        if (pattern == null) {
            return null;
        }
        Object[] tokens = MetricPatternUtils.parseMetricPattern(pattern);
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            Object token = tokens[i];
            if (token instanceof String) {
                sb.append(Pattern.quote((String)token));
                continue;
            }
            if (!(token instanceof Integer)) continue;
            sb.append("([^:\\|]+)");
        }
        return sb.toString();
    }
}

