/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator.common;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.servletheaderdecorator.common.AbstractMethodCache;
import com.wily.introscope.agent.servletheaderdecorator.common.PPAbstractTracer;
import com.wily.introscope.agent.trace.InvocationData;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class MultiMethodCache
extends AbstractMethodCache {
    private WeakHashMap[] m_methodCache = null;

    public MultiMethodCache(int size, String[] methodNames, String[] overrideClassNames) {
        this.m_methodCache = new WeakHashMap[size];
        this.m_methodNames = methodNames;
        this.m_overrideClassNames = overrideClassNames;
    }

    private Method cacheGet(int index, Class objClass) {
        if (this.m_methodCache[index] == null) {
            this.m_methodCache[index] = new WeakHashMap();
        }
        return (Method)this.m_methodCache[index].get(objClass);
    }

    private void cachePut(int index, Class objClass, Method method) {
        if (this.m_methodCache[index] == null) {
            this.m_methodCache[index] = new WeakHashMap();
        }
        this.m_methodCache[index].put(objClass, method);
    }

    @Override
    Method getMethod(Object object, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (object == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return null;
        }
        Class<?> objClass = object.getClass();
        Method method = this.cacheGet(methodIndex, objClass);
        if (method == null) {
            method = PPAbstractTracer.getMethodSignature(object, methodIndex, invocationData, argClassArray, false);
            this.cachePut(methodIndex, objClass, method);
        }
        return method;
    }

    @Override
    Method getMethodForClass(Class objClass, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (objClass == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": classObj is null"), null);
            return null;
        }
        Method method = this.cacheGet(methodIndex, objClass);
        if (method == null) {
            method = PPAbstractTracer.getMethodSignatureForClass(objClass, methodIndex, invocationData, argClassArray, false);
            this.cachePut(methodIndex, objClass, method);
        }
        return method;
    }

    @Override
    boolean isMethodPresent(Object obj, int methodIndex, Class[] argClassArray, String tracerName) {
        if (obj == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return false;
        }
        Class<?> objClass = obj.getClass();
        Method method = this.cacheGet(methodIndex, objClass);
        if (method == null) {
            method = PPAbstractTracer.getMethodSignature(obj, methodIndex, null, argClassArray, true);
            this.cachePut(methodIndex, objClass, method);
        }
        return method != null;
    }
}

