/*
 * Decompiled with CFR 0.152.
 */
package com.wily.EDU.oswego.cs.dl.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Sync;
import com.wily.EDU.oswego.cs.dl.util.concurrent.SyncCollection;
import com.wily.EDU.oswego.cs.dl.util.concurrent.SyncSet;
import com.wily.EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SyncMap
implements Map {
    protected final Map c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);
    private transient Set keySet_ = null;
    private transient Set entrySet_ = null;
    private transient Collection values_ = null;

    public SyncMap(Map map, Sync sync) {
        this(map, sync, sync);
    }

    public SyncMap(Map map, ReadWriteLock rwl) {
        this(map, rwl.readLock(), rwl.writeLock());
    }

    public SyncMap(Map map, Sync readLock, Sync writeLock) {
        this.c_ = map;
        this.rd_ = readLock;
        this.wr_ = writeLock;
    }

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException ex) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean wasInterrupted) {
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.c_.hashCode();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.equals(o);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.c_.size();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.isEmpty();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.containsKey(o);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.containsValue(o);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object v = this.c_.get(key);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return v;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        this.wr_.acquire();
        try {
            Object object = this.c_.put(key, value);
            {
                Object var5_5 = null;
                this.wr_.release();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                Object var5_6 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.wr_.acquire();
        try {
            Object v = this.c_.remove(key);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return v;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map coll) {
        try {
            this.wr_.acquire();
            try {
                this.c_.putAll(coll);
                Object var3_2 = null;
                this.wr_.release();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
                Object var2_1 = null;
                this.wr_.release();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        boolean wasInterrupted = this.beforeRead();
        try {
            if (this.keySet_ == null) {
                this.keySet_ = new SyncSet(this.c_.keySet(), this.rd_, this.wr_);
            }
            Set set = this.keySet_;
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        boolean wasInterrupted = this.beforeRead();
        try {
            if (this.entrySet_ == null) {
                this.entrySet_ = new SyncSet(this.c_.entrySet(), this.rd_, this.wr_);
            }
            Set set = this.entrySet_;
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        boolean wasInterrupted = this.beforeRead();
        try {
            if (this.values_ == null) {
                this.values_ = new SyncCollection(this.c_.values(), this.rd_, this.wr_);
            }
            Collection collection = this.values_;
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }
}

