/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.api;

import com.wily.introscope.agent.api.ADataRecorderImpl;
import com.wily.introscope.agent.api.IllegalValueException;
import com.wily.introscope.agent.api.PerIntervalCounterDataRecorder;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;

final class PerIntervalCounterDataRecorderImpl
extends ADataRecorderImpl
implements PerIntervalCounterDataRecorder {
    private static final String KNumberOfIncidentMustBePositiveMessage = "Number of incidents must be positive";

    PerIntervalCounterDataRecorderImpl(ILongIntervalCounterDataAccumulator backingAccumulator, MetricRecordingAdministrator metricRecordingAdministrator) {
        super(backingAccumulator, metricRecordingAdministrator);
    }

    private ILongIntervalCounterDataAccumulator getIntervalCounterDataAccumulator() {
        return (ILongIntervalCounterDataAccumulator)this.getBackingDataAccumulator();
    }

    @Override
    public void recordIncident() {
        if (!this.isShutoff()) {
            this.getIntervalCounterDataAccumulator().ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    @Override
    public void recordMultipleIncidents(int incidentCount) throws IllegalValueException {
        if (incidentCount < 0) {
            throw new IllegalValueException(KNumberOfIncidentMustBePositiveMessage);
        }
        if (!this.isShutoff()) {
            this.getIntervalCounterDataAccumulator().ILongIntervalCounterDataAccumulator_addBatchIncidents(incidentCount);
        }
    }
}

