/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncBackendEndTracer;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public abstract class AsyncHttpBackendEndTracer
extends AsyncBackendEndTracer {
    public IModuleFeedbackChannel feedback;
    public static final Module module = new Module("AsyncHttpBackendEndTracer");
    public final IAgent agent;
    private static final int UNKNOWN_STATUS_CODE = -1;
    private static final String SEP = " - ";

    public abstract boolean isNullDataResolver();

    public abstract int getHttpStatusCode(InvocationData var1);

    public abstract String getHttpStatusMessage(InvocationData var1);

    public AsyncHttpBackendEndTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.feedback = this.getAgent().IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            if (!data.hasInvocationThrownException() || this.showStatusCodeIfExceptionThrown()) {
                this.handleStatusCodeAndError(data);
            }
        }
        catch (ClassCastException castException) {
            this.feedback.error(module, "doOnEndTrace - expected \"elementData\" to be an instance of InvocationData");
            this.feedback.verbose(castException);
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    protected boolean showStatusCodeIfExceptionThrown() {
        return false;
    }

    protected boolean generateErrorForErrorStatusCode() {
        return true;
    }

    public void handleStatusCodeAndError(InvocationData data) {
        if (this.isNullDataResolver()) {
            return;
        }
        int statusCode = this.getHttpStatusCode(data);
        StringBuilder messageBuilder = null;
        if (statusCode == -1) {
            String ecStr = this.asyncStack.getComponentDecoratedWithParam(data, "HTTP Status Code", "Backend component");
            if (ecStr != null) {
                messageBuilder = new StringBuilder();
                statusCode = AsyncHttpBackendEndTracer.decomposeStatusCode(ecStr, messageBuilder);
            }
            if (statusCode == -1) {
                return;
            }
        }
        String statusMessage = null;
        statusMessage = messageBuilder != null && messageBuilder.length() > 0 ? messageBuilder.toString() : this.getHttpStatusMessage(data);
        String responseCode = AsyncHttpBackendEndTracer.composeStatusCode(statusCode, statusMessage);
        if (statusCode >= 400 && statusCode <= 599 && this.generateErrorForErrorStatusCode() && ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, responseCode)) {
            AsyncVirtualStack.decorateComponentWithError(data, responseCode);
        }
        this.asyncStack.decorateComponentWithParam(data, "HTTP Status Code", responseCode, "Backend component");
    }

    public static String composeStatusCode(int code, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append(code);
        if (message != null && message.length() > 0) {
            builder.append(SEP);
            builder.append(message);
        }
        return builder.toString();
    }

    public static int decomposeStatusCode(String composed, StringBuilder returnMessage) {
        int code = -1;
        if (composed != null) {
            composed = composed.trim();
        }
        if (composed.length() == 0) {
            return code;
        }
        char[] asChars = composed.toCharArray();
        int index = 0;
        boolean isNegative = false;
        if (asChars[index] == '-') {
            isNegative = true;
            ++index;
        } else if (asChars[index] == '+') {
            isNegative = false;
            ++index;
        }
        if (index >= asChars.length || !Character.isDigit(asChars[index])) {
            return code;
        }
        code = 0;
        while (index < asChars.length && Character.isDigit(asChars[index])) {
            code *= 10;
            code += Character.getNumericValue(asChars[index++]);
        }
        if (isNegative) {
            code *= -1;
        }
        index += SEP.length();
        while (returnMessage != null && index < asChars.length) {
            returnMessage.append(asChars[index++]);
        }
        return code;
    }
}

