/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncThreadFragmentTracer;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.InjectedFieldCorrelationHelper;
import com.wily.introscope.agent.blame.TransactionCache;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.Array;
import java.util.Map;

public class AsyncThreadFragmentCorrelationTracer
extends AsyncThreadFragmentTracer {
    private static final String debugMethodPropertyKey = "introscope.agent.async.debug.method";
    private String debugMethodName;
    private final boolean debugFlag;
    private final InjectedFieldCorrelationHelper correlationHelper;
    private static final String kContextObjextIndexKey = "contextObject";
    private static final String kKeepContextKey = "keepContext";
    private static final String kOverrideThreadCorrelationIdKey = "overrideThreadCorrelationId";
    private static final int USE_THIS_AS_CONTEXT = -1;
    private static final int USE_RETVAL_AS_CONTEXT = 9999;
    private final int contextObjectIndex;
    private final boolean keepContext = this.calculateBooleanParameter("keepContext", false);
    protected final IModuleFeedbackChannel feedback;
    private boolean overrideThreadCorrelationId = false;
    protected static Module module = new Module("AsyncThreadFragmentCorrelationTracer");
    public static final String kFragmentsCategoryPrefix = "Fragments|";

    public AsyncThreadFragmentCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.contextObjectIndex = this.calculateIntegerParameter(kContextObjextIndexKey, -1);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.correlationHelper = this.contextObjectIndex == -1 ? new InjectedFieldCorrelationHelper(agent, parameters, probe, sampleTracedObject) : new InjectedFieldCorrelationHelper(agent, parameters, probe, null);
        String overrideThreadCorrelationIdKey = parameters.get(kOverrideThreadCorrelationIdKey);
        if (overrideThreadCorrelationIdKey == null || overrideThreadCorrelationIdKey.trim().isEmpty()) {
            this.overrideThreadCorrelationId = false;
        } else {
            try {
                this.overrideThreadCorrelationId = Boolean.parseBoolean(overrideThreadCorrelationIdKey);
            }
            catch (RuntimeException rEx) {
                this.overrideThreadCorrelationId = false;
            }
        }
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String debugMethod = props.getProperty(debugMethodPropertyKey, null);
        if (debugMethod != null) {
            this.debugMethodName = probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName();
            this.debugFlag = this.debugMethodName.startsWith(debugMethod);
        } else {
            this.debugFlag = false;
        }
    }

    protected Object findContextObject(InvocationData data) {
        if (this.contextObjectIndex == -1) {
            return data.getInvocationObject();
        }
        if (this.contextObjectIndex == 9999) {
            return null;
        }
        return data.getInvocationParameterAsObject(this.contextObjectIndex);
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return AsyncVirtualStack.addFragmentPrefix(rootName);
    }

    @Override
    protected String getComponentName(InvocationData data) {
        if (!AsyncVirtualStack.reportFragmentsByFrontend()) {
            return super.getComponentName(data);
        }
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        String name = super.formatParameterizedName(data);
        String frontendName = null;
        if (frontendInfo != null) {
            frontendName = frontendInfo.componentName;
        }
        name = AsyncVirtualStack.formatFragmentName(frontendName, name);
        return this.getFrontendNameForComponent(name);
    }

    @Override
    protected Object getBlameKey(InvocationData data) {
        String compName = this.getComponentName(data);
        IBizTrx bizTrxKey = (IBizTrx)data.get("BusinessTrxData");
        if (bizTrxKey != null) {
            Object[] blameComp = (Object[])Array.newInstance(Object.class, 2);
            blameComp[0] = compName;
            blameComp[1] = bizTrxKey;
            long bizTrxKeyId = bizTrxKey.getId();
            ABlameComponent key = ABlameComponent.getArrayInstance(blameComp, bizTrxKeyId);
            return key;
        }
        return compName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean enabled;
        Object contextObject;
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " start trace called for " + this.debugMethodName);
        }
        if ((contextObject = this.findContextObject(data)) != null && (enabled = this.correlationHelper.processContext(data, contextObject, this.keepContext, this.overrideThreadCorrelationId))) {
            final AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
            if (frontendInfo != null) {
                if (frontendInfo.markedForAutoTrace) {
                    AutoTracingController.markForPriorityAutoTracing(data, frontendInfo.autoTraceReason, frontendInfo.autoTraceComponent);
                    data.setMarkedForDiscoveryTrace(true);
                }
                if (frontendInfo.bizTrx != null) {
                    TransactionCache cache = this.getTransactionCache(data);
                    data.put("BusinessTrxData", frontendInfo.bizTrx);
                    cache.setBizTrx(frontendInfo.bizTrx);
                }
            }
            super.ITracer_startTrace(tracerIndex, data);
            data.put("asyn.thread.correlation.inserted", true);
            data.setParameterCallback(new IInvocationDataParameterCallback(){

                @Override
                public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                    if (frontendInfo != null) {
                        String appName;
                        String frontendTxid = frontendInfo.transactionId;
                        if (frontendTxid != null) {
                            parameters.put("FrontendTxnTraceId", frontendTxid);
                        }
                        if ((appName = frontendInfo.applicationName) != null) {
                            parameters.put("Application Name", appName);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " finish trace called for " + this.debugMethodName);
        }
        if (data.get("asyn.thread.correlation.inserted") != null) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    @Override
    public ISamplingResult preSample(IStackElement data) {
        if (data == null || !(data instanceof InvocationData)) {
            return ISamplingResult.NO;
        }
        InvocationData invocationData = (InvocationData)data;
        AsyncTransactionContext.AsyncComponentInvocation invokation = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(invocationData);
        if (invokation == null) {
            return ISamplingResult.NO;
        }
        if (invokation.sampled != null) {
            return invokation.sampled;
        }
        return ISamplingResult.NO;
    }

    @Override
    protected void checkTrivialAsynchFragment(InvocationData data) {
        TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
        if (tcs != null) {
            tcs.isTrivialAsynchFragment = true;
        }
    }
}

