/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.InjectedFieldCorrelationHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncThreadHandoverCorrelationTracer
extends BackendTracer {
    private static final String debugMethodPropertyKey = "introscope.agent.async.debug.method";
    private String debugMethodName;
    private final boolean debugFlag;
    private static final String kContextObjextIndexKey = "contextObject";
    private static final int USE_THIS_AS_CONTEXT = -1;
    private static final int USE_RETVAL_AS_CONTEXT = 9999;
    private final InjectedFieldCorrelationHelper correlationHelper;
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncThreadHandoverCorrelationTracer");
    public static final String kHandoverCategoryPrefix = "Handovers|";
    private final boolean useBlame = this.calculateUseBlame(true);
    private final int contextObjectIndex = this.calculateIntegerParameter("contextObject", -1);

    public AsyncThreadHandoverCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.correlationHelper = this.contextObjectIndex == -1 ? new InjectedFieldCorrelationHelper(agent, parameters, probe, sampleTracedObject) : new InjectedFieldCorrelationHelper(agent, parameters, probe, null);
        this.feedback = agent.IAgent_getModuleFeedback();
        String debugMethod = agent.IAgent_getIndexedProperties().getProperty(debugMethodPropertyKey, null);
        if (debugMethod != null) {
            this.debugMethodName = probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName();
            this.debugFlag = this.debugMethodName.startsWith(debugMethod);
        } else {
            this.debugFlag = false;
        }
    }

    @Override
    protected boolean resolveGenerateBusinessTransactionMetricsProperty() {
        return false;
    }

    private Object findContextObject(InvocationData data) {
        if (this.contextObjectIndex == -1) {
            return data.getInvocationObject();
        }
        if (this.contextObjectIndex == 9999) {
            return data.getInvocationReturnValueAsObject();
        }
        return data.getInvocationParameterAsObject(this.contextObjectIndex);
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String prefix;
        String name = this.formatParameterizedName(data);
        String string = prefix = AsyncVirtualStack.reportFragmentsAsFrontend() ? "Backends|" : kHandoverCategoryPrefix;
        if (!name.contains(prefix)) {
            name = prefix + name;
        }
        return name;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " start trace called for " + this.debugMethodName);
        }
        Object contextObject = this.findContextObject(data);
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        if (this.useBlame && virtualCursor.getTopOfStack() == null) {
            if (this.debugFlag) {
                this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " handover called in empty stack");
            }
            return;
        }
        ITransactionCache currentCache = virtualCursor.getCurrentCache();
        Object correlationTracerInstance = currentCache.getFromCache("asyn.thread.correlation");
        if (correlationTracerInstance == null || correlationTracerInstance == InjectedFieldCorrelationHelper.nullObject) {
            currentCache.putInCache("asyn.thread.correlation", this);
            data.put("asyn.thread.correlation", true);
            if (contextObject != null) {
                this.correlationHelper.insertContext(data, contextObject);
                data.put("asyn.thread.correlation.inserted", true);
            }
            if (this.useBlame) {
                super.ITracer_startTrace(tracerIndex, data);
            }
        } else if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " handover called inside another handover");
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " finish trace called for " + this.debugMethodName);
        }
        if (data.get("asyn.thread.correlation") != null) {
            ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
            ITransactionCache currentCache = virtualCursor.getCurrentCache();
            Object correlationTracerInstance = currentCache.getFromCache("asyn.thread.correlation");
            if (correlationTracerInstance == this) {
                currentCache.putInCache("asyn.thread.correlation", InjectedFieldCorrelationHelper.nullObject);
                Object contextObject = this.findContextObject(data);
                if (contextObject != null && data.get("asyn.thread.correlation.inserted") == null) {
                    this.correlationHelper.insertContext(data, contextObject);
                } else if (this.debugFlag) {
                    this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " handover failed to find context object.");
                }
                if (this.useBlame) {
                    super.ITracer_finishTrace(tracerIndex, data);
                }
            } else if (this.debugFlag) {
                this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " handover inside handover finished.");
            }
        }
    }

    @Override
    public ISamplingResult preSample(IStackElement data) {
        return ISamplingResult.NO;
    }

    @Override
    protected void checkTrivialAsynchFragment(InvocationData data) {
    }
}

