/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.beans.autotracing;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.beans.AAgentBeanNameListener;
import com.wily.introscope.agent.beans.AAgentRemoteBean;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.agent.beans.autotracing.AgentMetricThresholdTrigger;
import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTrigger;
import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTriggerService;
import com.wily.isengard.IsengardException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class AutoTracingTriggerServiceBean
extends AAgentRemoteBean
implements IAutoTracingTriggerService {
    private String fNamedAgentName = null;
    private String fNamedAgentMetricPrefix = null;

    @Override
    public boolean setAutoTracingTriggers(IAutoTracingTrigger[] triggers) throws ConnectionException {
        if (triggers == null) {
            return false;
        }
        IIntelligentInstrumentationTracerHelper helper = this.getAgent().IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        if (helper == null) {
            return false;
        }
        return helper.setAutoTracingTriggers(triggers, this.fNamedAgentMetricPrefix);
    }

    @Override
    public boolean clearAutoTracingTriggers(IAutoTracingTrigger[] triggers) throws ConnectionException {
        if (triggers == null) {
            return false;
        }
        IIntelligentInstrumentationTracerHelper helper = this.getAgent().IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        if (helper == null) {
            return false;
        }
        return helper.clearAutoTracingTriggers(triggers, this.fNamedAgentMetricPrefix);
    }

    @Override
    public boolean clearAllAutoTracingTriggers() throws ConnectionException {
        IIntelligentInstrumentationTracerHelper helper = this.getAgent().IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        if (helper == null) {
            return false;
        }
        return helper.clearAllAutoTracingTriggers();
    }

    @Override
    public boolean updateAllAutoTraceingTriggers(IAutoTracingTrigger[] triggersToSet, IAutoTracingTrigger[] triggersToClear) throws ConnectionException {
        int triggerCount = triggersToSet.length;
        IAutoTracingTrigger[] triggers = new IAutoTracingTrigger[triggersToClear.length + triggersToSet.length];
        System.arraycopy(triggersToSet, 0, triggers, 0, triggerCount);
        for (int i = 0; i < triggersToClear.length; ++i) {
            if (triggersToClear[i] instanceof AgentMetricThresholdTrigger) {
                ((AgentMetricThresholdTrigger)triggersToClear[i]).setElapsedTimeThreshold(0L);
            }
            triggers[triggerCount + i] = triggersToClear[i];
        }
        return this.setAutoTracingTriggers(triggers);
    }

    @Override
    protected Class getServiceClass() {
        return IAutoTracingTriggerService.class;
    }

    @Override
    protected INameChangeListener createChangeListener() {
        return new AAgentBeanNameListener(this, this.getServiceClass()){

            @Override
            public void INameChangeListener_nameChanged(String newName) {
                if (AutoTracingTriggerServiceBean.this.fNamedAgentName == null) {
                    this.executeOnNameChanged(newName);
                } else {
                    this.executeOnNameChanged(AutoTracingTriggerServiceBean.this.fNamedAgentName);
                }
            }
        };
    }

    @Override
    public void activate() throws IsengardException {
        IAgent agent = (IAgent)this.getBeanDescriptor().getInstanceData();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        feedback.info("AutoTracingTriggerServiceBean activated.");
        if (agent instanceof IsengardServerConnectionManager.NamedAgentAdapter) {
            String name = ((IsengardServerConnectionManager.NamedAgentAdapter)agent).getName();
            this.fNamedAgentMetricPrefix = "!BRIDGE!" + name + "|";
            this.fNamedAgentName = agent.IAgent_getName();
            feedback.debug("AutoTracingTriggerServiceBean using metric prefix: " + this.fNamedAgentMetricPrefix);
        }
        super.activate();
    }

    @Override
    public void passivate() {
        super.passivate();
        this.getAgent().IAgent_getModuleFeedback().info("AutoTracingTriggerServiceBean passivated.");
    }
}

