/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.SubNetworkDescriptor;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SubNetworks {
    private static final int PRIVATE_IPV4_SUBNETS = 0;
    private static final int PRIVATE_IPV6_SUBNETS = 1;
    private static final int IPV6_TUNNELING_SUBNETS = 2;
    private static final String[] FIRST_WORDS = new String[]{"private", "tunnel"};
    private static final int PRIVATE = 0;
    private final List[] subNets = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};

    public SubNetworks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubNetworks(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer, InputStream subnetworksStream) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(subnetworksStream));
            String line = br.readLine();
            int lineNumber = 1;
            while (line != null) {
                if (!this.processLine(line)) {
                    feedback.error(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_Line_Format_Error", Integer.toString(lineNumber)));
                }
                line = br.readLine();
                ++lineNumber;
            }
        }
        catch (IOException e) {
            feedback.error(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_File_Read_Error", e.getMessage()));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean processLine(String line) {
        block10: {
            int slashPos;
            String subNetSpec;
            int hashPos = line.indexOf(35);
            if (hashPos >= 0) {
                line = line.substring(0, hashPos);
            }
            if ((line = line.trim()).length() == 0) {
                return true;
            }
            int firstWord = this.getFirstWord(line);
            if (firstWord >= 0 && (subNetSpec = line.substring(FIRST_WORDS[firstWord].length())).length() > 0 && Character.isWhitespace(subNetSpec.charAt(0)) && (slashPos = (subNetSpec = subNetSpec.trim()).indexOf(47)) > 0) {
                try {
                    SubNetworkDescriptor subNet = new SubNetworkDescriptor(subNetSpec.substring(0, slashPos), Integer.parseInt(subNetSpec.substring(slashPos + 1)));
                    if (subNet.isIPv4()) {
                        if (firstWord == 0) {
                            this.subNets[0].add(subNet);
                            return true;
                        }
                        break block10;
                    }
                    if (firstWord == 0) {
                        this.subNets[1].add(subNet);
                    } else {
                        this.subNets[2].add(subNet);
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private int getFirstWord(String line) {
        for (int i = 0; i < FIRST_WORDS.length; ++i) {
            if (!line.startsWith(FIRST_WORDS[i])) continue;
            return i;
        }
        return -1;
    }

    public List getPrivateIPv4SubNets() {
        return this.subNets[0];
    }

    public List getPrivateIPv6SubNets() {
        return this.subNets[1];
    }

    public List getIPv6TunnelingSubNets() {
        return this.subNets[2];
    }
}

