/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleChain;

public abstract class AbstractRule
implements Rule {
    @Override
    public void execute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status, RuleChain ruleChain) {
        boolean result = this.doExecute(currentElementIndex, trace, status);
        if (result) {
            status.markAsCandidate();
            if (Logger.isDebugEnabled()) {
                Logger.logDebugMessage("Rule: " + this.toString() + " has marked element:" + trace[currentElementIndex] + " as candidate.");
            }
        }
        ruleChain.doExecuteNextRule(currentElementIndex, trace, status);
    }

    public abstract boolean doExecute(int var1, IndexAwareTraceElement[] var2, ExecutionStatus var3);

    public String toString() {
        return CommonUtils.formatStringRep(this.getClass().getSimpleName());
    }
}

