/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.apis;

import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.StackTraceFilter;
import com.wily.introscope.agent.intelligent.entrypoint.apis.TraceFilterChain;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

class AStackTraceFilterChain
implements TraceFilterChain {
    private List<StackTraceFilter> filters = new CopyOnWriteArrayList<StackTraceFilter>();
    private Iterator<StackTraceFilter> filtersIter = this.filters.iterator();

    AStackTraceFilterChain() {
    }

    public boolean registerFilter(StackTraceFilter filter) {
        return this.filters.add(filter);
    }

    public boolean registerFilters(Set<StackTraceFilter> filters) {
        return this.filters.addAll(filters);
    }

    public boolean removeFilter(StackTraceFilter filter) {
        return this.filters.remove(filter);
    }

    protected IndexAwareTraceElement[] executeFilters(IndexAwareTraceElement[] trace) {
        this.resetFilterChain();
        return this.doExecuteNextFilter(trace);
    }

    @Override
    public IndexAwareTraceElement[] doExecuteNextFilter(IndexAwareTraceElement[] trace) {
        StackTraceFilter nextFilter = this.getNextFilter();
        if (nextFilter != null) {
            return nextFilter.filter(trace);
        }
        return trace;
    }

    private StackTraceFilter getNextFilter() {
        StackTraceFilter nextFilter = null;
        if (this.filtersIter.hasNext()) {
            nextFilter = this.filtersIter.next();
        }
        return nextFilter;
    }

    protected void resetFilterChain() {
        this.filtersIter = this.filters.iterator();
    }
}

