/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.AArfConnection;
import com.wily.introscope.agent.remote.arf.AArfTransport;
import com.wily.introscope.agent.remote.arf.ArfCommandConnection;
import com.wily.introscope.agent.remote.arf.ArfDataConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import com.wily.introscope.agent.remote.arf.TcpArfCommandConnection;
import com.wily.introscope.agent.remote.arf.TcpArfDataConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TCPArfTransport
extends AArfTransport {
    private final int fServerPort;
    private final boolean fLocalHostOnly;
    private ServerSocket fServerSocket;

    public TCPArfTransport(IAgent agent) {
        super(agent);
        this.fServerPort = -1;
        this.fLocalHostOnly = true;
    }

    public TCPArfTransport(IAgent agent, int port) {
        this(agent, port, true);
    }

    public TCPArfTransport(IAgent agent, int port, boolean acceptRemoteConnections) {
        super(agent);
        this.fServerPort = port;
        this.fLocalHostOnly = acceptRemoteConnections;
    }

    @Override
    public boolean initServer() {
        try {
            this.fServerSocket = !this.fLocalHostOnly ? new ServerSocket(this.fServerPort) : new ServerSocket(this.fServerPort, 0, InetAddress.getByName(null));
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Cannot create server socket on port " + this.fServerPort + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "ServerSocket(): ", e);
            return false;
        }
        return true;
    }

    @Override
    protected AArfConnection waitForNextConnection() throws SocketException {
        Socket clientSocket = null;
        BufferedReader in = null;
        try {
            String inputLine;
            clientSocket = this.fServerSocket.accept();
            in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            AArfConnection conn = null;
            while ((inputLine = in.readLine()) != null) {
                block12: {
                    try {
                        if (TCPArfTransport.isCommandConnection(inputLine)) {
                            conn = new TcpArfCommandConnection(this.fAgent, clientSocket, in, inputLine);
                            this.fFeedback.debug(this.kModule, "New tcp ARF command connection: " + inputLine);
                            break block12;
                        }
                        if (TCPArfTransport.isDataConnection(inputLine)) {
                            conn = new TcpArfDataConnection(this.fAgent, clientSocket, in, inputLine);
                            this.fFeedback.debug(this.kModule, "New tcp ARF data connection: " + inputLine);
                            break block12;
                        }
                        if (inputLine.trim().length() == 0) continue;
                        this.fFeedback.debug(this.kModule, "Attempted tcp connection on ARF port, but invalid handshake. ");
                        clientSocket.close();
                        return null;
                    }
                    catch (ArfException ae) {
                        this.fFeedback.error(this.kModule, "Failed to accept ARF connection: " + ae.getMessage());
                        this.fFeedback.debug(this.kModule, "Invalid handshake message: ", ae);
                        clientSocket.close();
                        in.close();
                        return null;
                    }
                }
                if (conn == null) continue;
                return conn;
            }
            in.close();
            clientSocket.close();
        }
        catch (IOException e) {
            try {
                if (in != null) {
                    in.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof SocketException) {
                throw (SocketException)e;
            }
            this.fFeedback.error(this.kModule, "Failed to accept ARF connection: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "accept(): ", e);
        }
        return null;
    }

    private Socket getSocket(String address) throws UnknownHostException, IOException {
        String[] args = address.split(":");
        String hostName = args[0];
        int portNumber = Integer.parseInt(args[1]);
        Socket socket = new Socket(hostName, portNumber);
        return socket;
    }

    @Override
    protected ArfDataConnection createArfDataConnection(String address) {
        Socket socket = null;
        TcpArfDataConnection dataConn = null;
        try {
            socket = this.getSocket(address);
            dataConn = new TcpArfDataConnection(this.fAgent, socket);
        }
        catch (UnknownHostException e) {
            this.fFeedback.error(this.kModule, "Failed to create socket to unknown host " + address + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return null;
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create socket to " + address + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return null;
        }
        return dataConn;
    }

    @Override
    protected ArfCommandConnection createArfCommandConnection(String address) {
        Socket socket = null;
        TcpArfCommandConnection commandConn = null;
        try {
            socket = this.getSocket(address);
            commandConn = new TcpArfCommandConnection(this.fAgent, socket);
        }
        catch (UnknownHostException e) {
            this.fFeedback.error(this.kModule, "Failed to create socket to unknown host " + address + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return null;
        }
        catch (ConnectException e) {
            this.fFeedback.error(this.kModule, "Failed to connect socket to " + address + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return null;
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create socket to " + address + ": " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return null;
        }
        return commandConn;
    }

    @Override
    public boolean closeServer() {
        try {
            this.fServerSocket.close();
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to close server socket: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Socket(): ", e);
            return false;
        }
        return true;
    }
}

