/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class InjectDelayTracer
extends ASingleInstanceTracerFactory {
    public static Module kModule = new Module("InjectDelayTracer");
    public final IModuleFeedbackChannel feedback;
    private final int delay;
    private final String name;

    public InjectDelayTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.delay = new Integer(this.getParameter("delay"));
        this.name = probe.getProbeClassName() + ":" + probe.getProbeMethodName() + probe.getProbeMethodDescriptor();
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.feedback.info(kModule, "Sleeping for " + this.delay + "seconds in " + this.name);
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }
}

