/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import java.util.concurrent.atomic.AtomicLong;

public class DoubleIntInLong {
    private final AtomicLong value = new AtomicLong(0L);
    static final long SECOND_MASK = 0xFFFFFFFFL;
    static final long SIGN_MASK = 0x80000000L;
    static final long FIRST_MASK = -4294967296L;

    public DoubleIntInLong(DoubleIntInLong valueAndCount2) {
        this.value.set(valueAndCount2.value.get());
    }

    public DoubleIntInLong() {
    }

    public void reset() {
        this.value.set(0L);
    }

    public void set(int first, int second) {
        long firstLong = this.packReference(first);
        long secondLong = this.packReference(second);
        this.value.set(firstLong + (secondLong <<= 32));
    }

    private long packReference(int ref) {
        long signBit = ref >>> 31;
        long sign = signBit * -1L + (signBit ^ 1L);
        long result = (long)ref * sign;
        return result += signBit << 31;
    }

    public int getSecond() {
        long packedRef = this.value.get() & 0xFFFFFFFFL;
        return (int)DoubleIntInLong.unpackReference(packedRef);
    }

    public static int getSecond(long packedValue) {
        long packedRef = packedValue & 0xFFFFFFFFL;
        return (int)DoubleIntInLong.unpackReference(packedRef);
    }

    public int getFirst() {
        long packedRef = this.value.get() & 0xFFFFFFFF00000000L;
        return (int)DoubleIntInLong.unpackReference(packedRef >>>= 32);
    }

    public static int getFirst(long packedValue) {
        long packedRef = packedValue & 0xFFFFFFFF00000000L;
        return (int)DoubleIntInLong.unpackReference(packedRef >>>= 32);
    }

    private static long unpackReference(long ref) {
        long sign = (ref & 0x80000000L) >>> 31;
        sign = sign * -1L + (sign ^ 1L);
        ref -= ref & 0x80000000L;
        return ref *= sign;
    }

    public int increase() {
        int currentCounterValue;
        int currentCount;
        long secondLong;
        long currentValue;
        do {
            currentValue = this.value.get();
            currentCounterValue = DoubleIntInLong.getFirst(currentValue);
            currentCount = DoubleIntInLong.getSecond(currentValue);
            long firstLong = this.packReference(++currentCounterValue);
        } while (!this.value.compareAndSet(currentValue, (firstLong <<= 32) + (secondLong = this.packReference(++currentCount))));
        return currentCounterValue;
    }

    public int decrease() {
        int currentCounterValue;
        int currentCount;
        long secondLong;
        long currentValue;
        do {
            currentValue = this.value.get();
            currentCounterValue = DoubleIntInLong.getFirst(currentValue);
            currentCount = DoubleIntInLong.getSecond(currentValue);
            long firstLong = this.packReference(--currentCounterValue);
        } while (!this.value.compareAndSet(currentValue, (firstLong <<= 32) + (secondLong = this.packReference(++currentCount))));
        return currentCounterValue;
    }

    public void setMinMax(int newValue) {
        int currentMaximum;
        long secondLong;
        long currentValue;
        do {
            currentValue = this.value.get();
            int currentMinimum = DoubleIntInLong.getFirst(currentValue);
            currentMaximum = DoubleIntInLong.getSecond(currentValue);
            if (newValue > currentMaximum) {
                currentMaximum = newValue;
            }
            if (newValue < currentMinimum) {
                currentMinimum = newValue;
            }
            long firstLong = this.packReference(currentMinimum);
        } while (!this.value.compareAndSet(currentValue, (firstLong <<= 32) + (secondLong = this.packReference(currentMaximum))));
    }

    public int add(int added) {
        int currentCounterValue;
        int currentCount;
        long secondLong;
        long currentValue;
        do {
            currentValue = this.value.get();
            currentCounterValue = DoubleIntInLong.getFirst(currentValue);
            currentCount = DoubleIntInLong.getSecond(currentValue);
            long firstLong = this.packReference(currentCounterValue += added);
        } while (!this.value.compareAndSet(currentValue, (firstLong <<= 32) + (secondLong = this.packReference(++currentCount))));
        return currentCounterValue;
    }

    public int merge(int mergedValue, int mergedCount) {
        int currentCounterValue;
        long secondLong;
        long currentValue;
        do {
            currentValue = this.value.get();
            currentCounterValue = DoubleIntInLong.getFirst(currentValue);
            int currentCount = DoubleIntInLong.getSecond(currentValue);
            long firstLong = this.packReference(currentCounterValue += mergedValue);
        } while (!this.value.compareAndSet(currentValue, (firstLong <<= 32) + (secondLong = this.packReference(currentCount += mergedCount))));
        return currentCounterValue;
    }

    public String toString() {
        return "[" + this.getFirst() + ";" + this.getSecond() + "]";
    }
}

