/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.DoubleIntInLong;
import com.wily.introscope.agent.trace.cas.ICASSharedElement;
import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.hc2.BaseMetricGathererWrapper;

public class AtomicCountMetricGathererWrapper
extends BaseMetricGathererWrapper
implements ICASSharedElement {
    private final DoubleIntInLong valueAndCount;
    private final DoubleIntInLong minAndMax;

    protected AtomicCountMetricGathererWrapper(boolean shouldBeConsumedOnRead) {
        super(shouldBeConsumedOnRead);
        this.valueAndCount = new DoubleIntInLong();
        this.minAndMax = new DoubleIntInLong();
    }

    public AtomicCountMetricGathererWrapper(boolean b, DoubleIntInLong valueAndCount2, DoubleIntInLong minAndMax2) {
        super(b);
        this.valueAndCount = new DoubleIntInLong(valueAndCount2);
        this.minAndMax = new DoubleIntInLong(minAndMax2);
    }

    public ISharedElement getThreadSafeBookmark() {
        return new AtomicCountMetricGathererWrapper(this.shouldBeConsumendOnRead(), this.valueAndCount, this.minAndMax);
    }

    @Override
    public void merge(IGathererElement other) {
        int otherCount;
        long packedValue;
        if (other instanceof AtomicCountMetricGathererWrapper) {
            packedValue = ((AtomicCountMetricGathererWrapper)other).getValue();
            otherCount = DoubleIntInLong.getSecond(packedValue);
            if (otherCount == 0) {
                return;
            }
        } else {
            throw new RuntimeException("Cannot merge atomic with " + other.getClass());
        }
        int otherValue = DoubleIntInLong.getFirst(packedValue);
        int mergedCount = this.valueAndCount.getSecond() + otherCount;
        int mergedValue = this.valueAndCount.getFirst() + otherValue;
        this.valueAndCount.set(mergedValue, mergedCount);
        long otherMin = other.getMinimum();
        long otherMax = other.getMaximum();
        this.updateMinMax(mergedValue, otherMin, otherMax);
    }

    private void updateMinMax(long otherMin, long otherMax, long mergedValue) {
        long proposedMin = mergedValue < otherMin ? mergedValue : otherMin;
        long proposedMax = mergedValue > otherMax ? mergedValue : otherMax;
        this.minAndMax.setMinMax((int)proposedMin);
        this.minAndMax.setMinMax((int)proposedMax);
    }

    @Override
    public void combineValue(long value) {
        int newValue = this.valueAndCount.add((int)value);
        this.minAndMax.setMinMax(newValue);
    }

    @Override
    public void decrease(long startTime) {
        int newValue = this.valueAndCount.decrease();
        this.minAndMax.setMinMax(newValue);
        this.combineTime(startTime);
    }

    @Override
    public long getCount() {
        return this.valueAndCount.getSecond();
    }

    @Override
    public IGathererElement getInstance() {
        return new AtomicCountMetricGathererWrapper(this.shouldBeConsumendOnRead());
    }

    @Override
    public long getMaximum() {
        return this.minAndMax.getSecond();
    }

    @Override
    public long getMinimum() {
        return this.minAndMax.getFirst();
    }

    @Override
    public long getValue() {
        return this.valueAndCount.getFirst();
    }

    @Override
    public void increase(long startTime) {
        int newValue = this.valueAndCount.increase();
        this.minAndMax.setMinMax(newValue);
        this.combineTime(startTime);
    }

    @Override
    public void reset() {
        this.valueAndCount.reset();
        this.minAndMax.reset();
    }

    @Override
    public ICASSharedElement getCASInstance() {
        return (ICASSharedElement)this.getInstance();
    }

    @Override
    public ISharedElement getSharedElementInstance() {
        return (ISharedElement)this.getInstance();
    }

    @Override
    public void resetMinMax() {
        this.minAndMax.reset();
    }

    @Override
    public void setValue(long value) {
    }

    @Override
    public void increase(long endTime, long startTime) {
        this.increase(startTime);
    }

    @Override
    public void decrease(long endTime, long startTime) {
        this.decrease(startTime);
    }
}

