/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.MetricPathUtils;
import com.wily.introscope.agent.trace.hc2.HttpServletTracer;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.util.StringUtils;
import com.wily.util.adt.LazyMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpServletLazyMap
extends LazyMap {
    final IServletRequestHelper helper;
    final Object request;
    final IAgent agent;
    Object requestURI;
    Object httpMethod;
    Object serverName;
    Object serverPortAsInteger;
    Object remoteAddr;
    Object servletContext;

    public HttpServletLazyMap(IAgent agent, IServletRequestHelper helper, Object request, Object servlet, LazyMap.ILazyMapProvider provider, HashMap hashMap, Set accessoryKeys) {
        super(provider, hashMap, accessoryKeys, false);
        this.agent = agent;
        this.helper = helper;
        this.request = request;
    }

    Object getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.helper.getRequestURI(this.request);
            this.put("URL", this.requestURI);
        }
        return this.requestURI;
    }

    Object getMethod() {
        if (this.httpMethod == null) {
            this.httpMethod = this.helper.getMethod(this.request);
            this.put("HTTP Method", this.httpMethod);
        }
        return this.httpMethod;
    }

    Object getServerName() {
        if (this.serverName == null) {
            this.serverName = this.helper.getServerName(this.request);
            this.put("Server Name", this.serverName);
        }
        return this.serverName;
    }

    Object getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.helper.getRemoteAddr(this.request);
            this.put("Remote Client Address", this.remoteAddr);
        }
        return this.remoteAddr;
    }

    Object getServerPortAsInteger() {
        if (this.serverPortAsInteger == null) {
            this.serverPortAsInteger = this.helper.getServerPortAsInteger(this.request);
        }
        return this.serverPortAsInteger;
    }

    Object getServletContext() {
        if (this.servletContext == null) {
            this.servletContext = this.get("Application Name");
        }
        return this.servletContext;
    }

    Object getSyntheticTransactionName() {
        if (HttpServletTracer.sSyntheticHeaderParameterNames == null) {
            return null;
        }
        StringBuffer sb = null;
        for (String syntheticParameterName : HttpServletTracer.sSyntheticHeaderParameterNames) {
            String syntheticTransactionName;
            if (syntheticParameterName == null || StringUtils.isEmpty(syntheticTransactionName = (String)this.get(syntheticParameterName))) continue;
            syntheticTransactionName = "httprequest.header.x-wtg-info".equals(syntheticParameterName) ? this.getSyntheticTransactionNameFromWTGInfo(syntheticTransactionName) : ("httprequest.header.lisaframeid".equals(syntheticParameterName) ? "CA LISA" : MetricPathUtils.convertToValidMetricPath(syntheticTransactionName));
            sb = new StringBuffer();
            sb.append(HttpServletTracer.sSyntheticNodeName);
            String syntheticUserName = (String)this.get(HttpServletTracer.sSyntheticUserParameterName);
            if (!StringUtils.isEmpty(syntheticUserName)) {
                sb.append("|" + MetricPathUtils.convertToValidMetricPath(syntheticUserName));
            }
            sb.append("|" + syntheticTransactionName);
            break;
        }
        if (sb != null) {
            return sb.toString();
        }
        if (StringUtils.isEmpty(HttpServletTracer.sNonSyntheticNodeName)) {
            return null;
        }
        return HttpServletTracer.sNonSyntheticNodeName;
    }

    private String getSyntheticTransactionNameFromWTGInfo(String wtgInfo) {
        StringTokenizer st = new StringTokenizer(wtgInfo, "&");
        String requestId = "Action";
        String ipAddress = "0.0.0.0";
        String scriptName = "unknownScript";
        String scriptGroup = "unknownGroup";
        while (st.hasMoreTokens()) {
            int tempint;
            String currentInfo = st.nextToken().trim();
            if (currentInfo.startsWith("request_id=")) {
                tempint = currentInfo.indexOf("=");
                requestId = MetricPathUtils.convertToValidMetricPath(currentInfo.substring(tempint + 1).trim());
            }
            if (currentInfo.startsWith("ipaddress=")) {
                tempint = currentInfo.indexOf("=");
                ipAddress = MetricPathUtils.convertToValidMetricPath(currentInfo.substring(tempint + 1).trim());
            }
            if (currentInfo.startsWith("name=")) {
                tempint = currentInfo.indexOf("=");
                scriptName = MetricPathUtils.convertToValidMetricPath(currentInfo.substring(tempint + 1).trim());
            }
            if (!currentInfo.startsWith("group=")) continue;
            tempint = currentInfo.indexOf("=");
            scriptGroup = MetricPathUtils.convertToValidMetricPath(currentInfo.substring(tempint + 1).trim());
        }
        return ipAddress + "|" + scriptGroup + "|" + scriptName + "|" + requestId;
    }

    void putAllParameters(Map target) {
        Object value;
        for (Object key : this.getProviderKeys()) {
            value = this.get(key);
            if (value == null || !(value instanceof String)) continue;
            target.put(key, value);
        }
        for (Object key : this.getAdditionalKeys()) {
            value = this.get(key);
            if (value == null || !(value instanceof String)) continue;
            target.put(key, value);
        }
    }
}

