/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.agent.beans.autotracing.AgentMetricThresholdTrigger;
import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTrigger;
import com.wily.introscope.spec.metric.AgentMetric;

public class AutoTracingHelper {
    public static boolean sAutoTracingEnabled = true;
    public static boolean useDetailedTriggerReason = true;

    public static boolean checkForAutoTracing(IStackElement element) {
        if (sAutoTracingEnabled && element instanceof InvocationData) {
            InvocationData data = (InvocationData)element;
            AutoTracingCollectStatus aTCS = data.getAutoTracingCollectStatus();
            return AutoTracingHelper.checkForAutoTracing(data, aTCS);
        }
        return false;
    }

    public static boolean checkForAutoTracing(InvocationData data, AutoTracingCollectStatus atcs) {
        if (sAutoTracingEnabled) {
            boolean isLocalAutoTraceMarked = AutoTracingHelper.checkLocalAutoTraceTrigger(atcs);
            if (isLocalAutoTraceMarked) {
                return true;
            }
            return AutoTracingHelper.checkAndPropagateCrossProcessAutoTraceTrigger(data, atcs);
        }
        return false;
    }

    public static boolean checkForAutoTracingWithClamp() {
        if (sAutoTracingEnabled) {
            AutoTracingCollectStatus aTCS = VirtualStack.getTransactionCache().getAutoTracingCollectStatus();
            return AutoTracingHelper.checkForAutoTracingWithClamp(aTCS);
        }
        return false;
    }

    public static boolean checkForAutoTracingWithClamp(AutoTracingCollectStatus atcs) {
        boolean isLocalAutoTraceMarked;
        if (sAutoTracingEnabled && (isLocalAutoTraceMarked = AutoTracingHelper.checkLocalAutoTraceTrigger(atcs))) {
            if (atcs.isPriorityTrace()) {
                return AutoTracingClampHelper.checkPriorityClampAndIncrement();
            }
            return AutoTracingClampHelper.checkClampAndIncrement();
        }
        return false;
    }

    public static void markForAutoTracingInternal(InvocationData data, String reason, String component) {
        AutoTracingHelper.markForAutoTracingInternal(data, reason, component, false);
    }

    public static void markForAutoTracingInternal(InvocationData data, String reason, String component, boolean isPriority) {
        if (!sAutoTracingEnabled) {
            return;
        }
        AutoTracingHelper.markForLocalAutoTraceTrigger(data, reason, component, isPriority);
        AutoTracingHelper.markForCrossProcessAutoTraceTrigger(data, reason, component, isPriority);
    }

    public static void clearAutoTracingInternal(InvocationData data) {
        AutoTracingHelper.clearLocalAutoTraceTrigger(data);
        AutoTracingHelper.clearCrossProcessAutoTraceTrigger(data);
    }

    private static boolean checkLocalAutoTraceTrigger(AutoTracingCollectStatus aTCS) {
        return aTCS != null && aTCS.shouldTrace();
    }

    public static boolean checkAndPropagateCrossProcessAutoTraceTrigger(InvocationData data, AutoTracingCollectStatus atcs) {
        String autoTracedParam;
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache != null && (autoTracedParam = cache.getStringParamIn("IsAutoTraced")) != null && !autoTracedParam.equals("0")) {
            String[] tokens = autoTracedParam.split(":");
            if (tokens.length < 2) {
                return false;
            }
            boolean priority = !tokens[0].equals("0");
            String reason = tokens[1];
            String component = null;
            if (tokens.length > 2) {
                component = tokens[2];
            }
            if (!reason.startsWith("Cross Process Trigger")) {
                reason = "Cross Process Trigger - " + reason;
            }
            AutoTracingHelper.markForAutoTracingInternal(data, reason, component, priority);
            AsyncVirtualStack.markForAutoTracing(data, reason, component, true);
            return true;
        }
        return false;
    }

    private static void markForLocalAutoTraceTrigger(InvocationData data, String reason, String component, boolean isPriority) {
        AutoTracingCollectStatus status = data.getAutoTracingCollectStatus();
        if (status == null) {
            status = new AutoTracingCollectStatus();
            data.setAutoTracingCollectStatus(status);
        }
        status.addTraceComponent(reason, component, isPriority);
    }

    private static void markForCrossProcessAutoTraceTrigger(InvocationData data, String reason, String component, boolean isPriority) {
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache == null) {
            data.ensureCrossProcessCache();
            cache = data.getSharedCrossProcessData();
        }
        StringBuilder autoTracingParam = new StringBuilder(isPriority ? "1" : "0");
        autoTracingParam.append(":");
        autoTracingParam.append(reason);
        if (component != null) {
            autoTracingParam.append(":");
            autoTracingParam.append(component);
        }
        cache.addParamOut("IsAutoTraced", autoTracingParam.toString());
    }

    private static void clearLocalAutoTraceTrigger(InvocationData data) {
        AutoTracingCollectStatus aTCS = data.getAutoTracingCollectStatus();
        if (aTCS != null) {
            aTCS.clear();
        }
    }

    private static void clearCrossProcessAutoTraceTrigger(InvocationData data) {
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache.getStringParamOut("IsAutoTraced") != null) {
            cache.addParamOut("IsAutoTraced", "0");
        }
    }

    public static boolean setAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        if (triggers.length > 0 && triggers[0] instanceof AgentMetricThresholdTrigger) {
            AgentMetricThresholdTrigger[] thresholds = new AgentMetricThresholdTrigger[triggers.length];
            for (int i = 0; i < triggers.length; ++i) {
                if (!(triggers[i] instanceof AgentMetricThresholdTrigger)) continue;
                AgentMetricThresholdTrigger trigger = (AgentMetricThresholdTrigger)triggers[i];
                if (metricPrefix != null) {
                    trigger = new AgentMetricThresholdTrigger(new AgentMetric.AgentMetricKey(metricPrefix + trigger.getMetricKey().getAttributeURL(), trigger.getMetricKey().getAttributeType()), trigger.getElapsedTimeThreshold());
                }
                thresholds[i] = trigger;
            }
            return WilyTransactionStructure.getInstance().setElapsedTimeAutoTracingThresholds(thresholds);
        }
        return false;
    }

    public static boolean clearAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        if (triggers.length > 0 && triggers[0] instanceof AgentMetricThresholdTrigger) {
            AgentMetricThresholdTrigger[] thresholds = new AgentMetricThresholdTrigger[triggers.length];
            for (int i = 0; i < triggers.length; ++i) {
                if (!(triggers[i] instanceof AgentMetricThresholdTrigger)) continue;
                AgentMetricThresholdTrigger trigger = (AgentMetricThresholdTrigger)triggers[i];
                if (metricPrefix != null) {
                    trigger = new AgentMetricThresholdTrigger(new AgentMetric.AgentMetricKey(metricPrefix + trigger.getMetricKey().getAttributeURL(), trigger.getMetricKey().getAttributeType()), trigger.getElapsedTimeThreshold());
                }
                thresholds[i] = trigger;
            }
            return WilyTransactionStructure.getInstance().clearElapsedTimeAutoTracingThresholds(thresholds);
        }
        return false;
    }

    public static boolean clearAllAutoTracingTriggers() {
        WilyTransactionStructure.getInstance().clearAllElapsedTimeAutoTracingThresholds();
        return true;
    }
}

