/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentFilter;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentIntervalCounter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

public class HighPerformanceIntelligentErrorSnapshotFilter {
    public static String kErrorSnapshotClampKey = "introscope.agent.errorsnapshots.throttle";
    public static int kIntelligentInstrumentationErrorComponentSingleMax_default = 500;
    public static String kIntelligentInstrumentationErrorComponentSingleMaxKey = "introscope.agent.deep.instrumentation.error.componentcount.single.max";
    public static String kIntelligentInstrumentationErrorComponentSingleMaxDesp = "IntelligentInstrumentationErrorComponentCountSingleMax";
    public static int kIntelligentInstrumentationErrorComponentTotalMax_default = 5000;
    public static String kIntelligentInstrumentationErrorComponentTotalMaxKey = "introscope.agent.deep.instrumentation.error.componentcount.total.max";
    public static String kIntelligentInstrumentationErrorComponentTotalMaxDesp = "IntelligentInstrumentationErrorComponentCountTotalMax";
    private static final HighPerformanceIntelligentErrorSnapshotFilter fErrorFilter = new HighPerformanceIntelligentErrorSnapshotFilter();
    private boolean fInitialized = false;
    private int fErrorComponentCountSingleMax = kIntelligentInstrumentationErrorComponentSingleMax_default;
    private int fErrorComponentCountTotalMax = kIntelligentInstrumentationErrorComponentTotalMax_default;
    private int fErrorCountClamp = 10;
    private HighPerformanceIntelligentIntervalCounter fIntervalCounter = null;

    private HighPerformanceIntelligentErrorSnapshotFilter() {
    }

    public static HighPerformanceIntelligentErrorSnapshotFilter getInstance() {
        return fErrorFilter;
    }

    public void initialize(IAgent agent) {
        if (agent == null) {
            return;
        }
        if (this.fInitialized) {
            return;
        }
        this.fErrorCountClamp = agent.IAgent_getIndexedProperties().getIntProperty(kErrorSnapshotClampKey);
        this.createComponentCountConfigParameters(agent);
        this.fIntervalCounter = new HighPerformanceIntelligentIntervalCounter("Error Snapshot", agent.IAgent_getCommonHeartbeat());
        this.fInitialized = true;
    }

    public void updateErrorCounter(IAgent agent, TransactionComponentData root, int totalComponents) {
        if (this.fIntervalCounter != null) {
            this.fIntervalCounter.increaseCounter(1, totalComponents);
        }
    }

    public int getErrorSnapshotThrottleState() {
        if (!this.isInitialized()) {
            return 5;
        }
        if (this.fErrorCountClamp <= 0) {
            return 7;
        }
        int throttleState = 5;
        int[] counts = this.fIntervalCounter.getCurrentCounts();
        int transactionCount = counts[0];
        int componentCount = counts[1];
        double expectedComponents = (double)transactionCount * (double)this.fErrorComponentCountTotalMax / (double)this.fErrorCountClamp;
        double extraComponents = ((double)transactionCount + 0.5) * (double)this.fErrorComponentCountTotalMax / (double)this.fErrorCountClamp;
        String stateMessage = " ";
        if ((double)componentCount <= expectedComponents) {
            throttleState = 5;
            stateMessage = "ErrorSnapshotThrottleState_None";
        } else if ((double)componentCount <= extraComponents) {
            throttleState = 6;
            stateMessage = "ErrorSnapshotThrottleState_ReduceII";
        } else {
            throttleState = 7;
            stateMessage = "ErrorSnapshotThrottleState_DisableII";
        }
        IAgent agent = HighPerformanceIntelligentFilter.getAgent();
        if (agent != null && agent.IAgent_getModuleFeedback().isDebugEnabled()) {
            agent.IAgent_getModuleFeedback().debug("Intelligent Error Snapshot Throttle state: " + stateMessage + " snapshots: " + transactionCount + " components: " + componentCount);
        }
        return throttleState;
    }

    public int getSingleErrorSnapshotComponentsMax() {
        return this.fErrorComponentCountSingleMax;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    public void setComponentCountSingleMax(int inValue) {
        this.fErrorComponentCountSingleMax = inValue;
    }

    public void setComponentCountTotalMax(int inValue) {
        this.fErrorComponentCountTotalMax = inValue;
    }

    private void createComponentCountConfigParameters(IAgent agent) {
        ConfigurationManager configurationManager = agent.IAgent_getConfigurationManager();
        Module module = agent.IAgent_getModule();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        PositiveIntegerConfigurationProperty singleMax = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationErrorComponentSingleMaxKey, kIntelligentInstrumentationErrorComponentSingleMax_default, kIntelligentInstrumentationErrorComponentSingleMaxDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_ComponentCount_Single_Max", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value < 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_ComponentCount_Single_Max", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentErrorSnapshotFilter.this.setComponentCountSingleMax((Integer)value);
            }
        };
        configurationManager.add(singleMax, true);
        PositiveIntegerConfigurationProperty totalMax = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationErrorComponentTotalMaxKey, kIntelligentInstrumentationErrorComponentTotalMax_default, kIntelligentInstrumentationErrorComponentTotalMaxDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_ComponentCount_Total_Max", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value < 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_ComponentCount_Total_Max", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentErrorSnapshotFilter.this.setComponentCountTotalMax((Integer)value);
            }
        };
        configurationManager.add(totalMax, true);
    }
}

