/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.ISocketNameFormatter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.properties.AttributeListing;

public abstract class ASocketCounter
extends ABundledTracerFactory {
    public ASocketCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IDataAccumulator getAccumulator(InvocationData data) {
        int position = this.getMetricPosition();
        IDataAccumulator current = ((SocketFormatMetricsCache)data.getPartialSocketFormattedName()).getAccumulators(position);
        if (current == null) {
            current = this.createDataAccumulator(data);
            ((SocketFormatMetricsCache)data.getPartialSocketFormattedName()).setAccumulators(current, position);
        }
        return current;
    }

    protected abstract IDataAccumulator createDataAccumulator(InvocationData var1);

    protected final String quickFormat(InvocationData data, int socketMetricPosition) {
        String value = this.getFormattedName();
        try {
            ISocketNameFormatter formatter = (ISocketNameFormatter)((Object)this.getCustomNameFormatter());
            value = formatter.ISocketNameFormatter_format(value, data, socketMetricPosition);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Formatting_Name_Error_Message", value, this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()));
            this.getModuleFeedback().verbose(t);
        }
        return value;
    }

    protected abstract int getMetricPosition();
}

