/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;

public class SocketAcceptNameFormatter
extends ASocketNameFormatter {
    public SocketAcceptNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected ASocketNameFormatter.ResourceAndAddress getResourceAndAddress(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof ServerSocketChannel) {
            String resourceName = SocketChannelMap.getResourceName(invocationObject);
            InetSocketAddress address = new InetSocketAddress(((ServerSocketChannel)invocationObject).socket().getLocalPort());
            if (resourceName != null && address != null) {
                return new ASocketNameFormatter.ResourceAndAddress(resourceName, address);
            }
        }
        return null;
    }
}

