/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.DuplicateHandlingBlameStack;
import com.wily.introscope.agent.blame.IAllocatorChangeListener;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBlameStackAllocator;
import com.wily.introscope.agent.blame.NullBlameStack;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

public class ExtensionsBlameStackAllocator
implements IBlameStackAllocator {
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ITransactionTraceListener fListener;
    private IAllocatorChangeListener fChangeListener;
    private Class fRegisteredExtensionBlameStack;
    private int fTraceClamp;
    private long fCacheFlushFrequency;
    private boolean fTraceEnabled;
    private IAgent fAgent;
    private IConfigurationListener fConfigListener;
    public static final String kBundledTraceEnablingProperty = "com.wily.introscope.agent.transactiontrace.boundaryTracing.enable";
    public static final String kBundledTraceClampProperty = "com.wily.introscope.agent.transactiontrace.boundaryTracing.clamp";
    public static final String kBundledTraceCacheFlushFrequency = "com.wily.introscope.agent.transactiontrace.boundaryTracing.cacheFlushFrequency";
    public static final int kBundledTraceSizeDefaultValue = 1000;
    public static final int kBundledTraceClampDefaultValue = 10000;
    public static final long kBundledTraceCacheFlushDefaultValue = 30L;
    private static final long kNumberOfMillisecsInOneDay = 86400000L;

    public ExtensionsBlameStackAllocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, IAgent agent) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fListener = listener;
        this.fChangeListener = null;
        this.fAgent = agent;
    }

    private void checkAndUpdate(IndexedProperties props) {
        int traceClamp = props.getIntProperty(kBundledTraceClampProperty, 10000);
        boolean traceEnabled = props.getBooleanProperty(kBundledTraceEnablingProperty, true);
        long cacheFlushFrequency = props.getLongProperty(kBundledTraceCacheFlushFrequency, 30L) * 86400000L;
        if (traceClamp != this.fTraceClamp || traceEnabled != this.fTraceEnabled || this.fCacheFlushFrequency != cacheFlushFrequency) {
            this.fTraceClamp = traceClamp;
            this.fTraceEnabled = traceEnabled;
            this.fCacheFlushFrequency = cacheFlushFrequency;
            this.fFeedback.info("DependencyMap properties were changed and reconfigured");
        }
    }

    public boolean isTraceExtensionEnabled() {
        return this.fTraceEnabled;
    }

    public void registerExtensionBlameStack(Class extensionStack) {
        this.fTraceClamp = this.fAgent.IAgent_getIndexedProperties().getIntProperty(kBundledTraceClampProperty, 10000);
        this.fTraceEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kBundledTraceEnablingProperty, true);
        this.fCacheFlushFrequency = this.fAgent.IAgent_getIndexedProperties().getLongProperty(kBundledTraceCacheFlushFrequency, 30L) * 86400000L;
        this.fConfigListener = new ExtensionStackConfigurationListener(this);
        this.fAgent.addConfigurationListener(this.fConfigListener);
        this.fRegisteredExtensionBlameStack = extensionStack;
    }

    @Override
    public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
        if (this.fTraceEnabled) {
            try {
                Constructor c = this.fRegisteredExtensionBlameStack.getConstructor(IModuleFeedbackChannel.class, IStringLocalizer.class, ITransactionTraceListener.class, Integer.class, Long.class);
                return new DuplicateHandlingBlameStack((IBlameStack)c.newInstance(this.fFeedback, this.fLocalizer, this.fListener, this.fTraceClamp, this.fCacheFlushFrequency));
            }
            catch (Exception e) {
                this.fAgent.IAgent_getModuleFeedback().error("ExtensionsBlameStackAllocator: allocate blame stack failed with " + e.getMessage());
                this.fAgent.IAgent_getModuleFeedback().debug(e);
            }
        } else if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().debug("ExtensionsBlameStackAllocator: allocating a NullBlameStack since BundleTrace was disabled");
        }
        return new NullBlameStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
        ExtensionsBlameStackAllocator extensionsBlameStackAllocator = this;
        synchronized (extensionsBlameStackAllocator) {
            if (this.fChangeListener != null) {
                Assertion.wilyFail("Error: only one listener currently supported");
            }
            this.fChangeListener = listener;
        }
    }

    private static class ExtensionStackConfigurationListener
    implements IConfigurationListener {
        ExtensionsBlameStackAllocator parent;

        public ExtensionStackConfigurationListener(ExtensionsBlameStackAllocator parent) {
            this.parent = parent;
        }

        @Override
        public void onChange(IndexedProperties props) {
            this.parent.checkAndUpdate(props);
        }
    }
}

