/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class AgentFileUtil {
    public static AgentFileUtil instance;
    private IAgent agent = null;
    private IModuleFeedbackChannel feedback;
    private IResource agentResource;
    private GroupPrincipal agentGroup;
    private boolean isPosix;
    private boolean isAgentSharedByGroup = false;
    private final String agentSharedByGroupKey = "introscope.agent.shared.posix.group";

    public static void initialize(IAgent agent) {
        instance = new AgentFileUtil();
        instance.initializeAgent(agent);
    }

    public static void fixGroupPermissionsAndOwner(File file) {
        if (instance != null) {
            instance._fixGroupPermissions(file);
        }
    }

    private void initializeAgent(IAgent a) {
        if (a == null) {
            return;
        }
        this.agent = a;
        this.feedback = this.agent.IAgent_getModuleFeedback();
        IndexedProperties props = this.agent.IAgent_getIndexedProperties();
        try {
            this.isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
            if (this.isPosix) {
                this.isAgentSharedByGroup = props.getBooleanProperty("introscope.agent.shared.posix.group", this.isAgentSharedByGroup);
                if (this.isAgentSharedByGroup) {
                    this.agentResource = this.agent.IAgent_getConfigurationResource();
                    File profileFile = new File(this.agentResource.IResource_getLocation());
                    Path profilePath = profileFile.toPath();
                    this.agentGroup = Files.readAttributes(profilePath, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group();
                }
            }
        }
        catch (IOException e) {
            this.feedback.error(e);
        }
        catch (Exception e) {
            this.feedback.error(e);
        }
    }

    private void _fixGroupPermissions(File file) {
        if (this.agent == null) {
            return;
        }
        if (this.isPosix && this.isAgentSharedByGroup) {
            try {
                Path path = file.toPath();
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (perms != null) {
                    if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                        perms.add(PosixFilePermission.GROUP_READ);
                    }
                    if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                        perms.add(PosixFilePermission.GROUP_WRITE);
                    }
                    if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                        perms.add(PosixFilePermission.GROUP_EXECUTE);
                    }
                    Files.setPosixFilePermissions(path, perms);
                }
                if (this.agentGroup != null) {
                    PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                    view.setGroup(this.agentGroup);
                }
            }
            catch (IOException e) {
                this.feedback.error(e);
            }
        }
    }
}

