/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

public class ByteClassUtil {
    public static final int CLASS_MAGIC = -889275714;
    private static char kDotSeparator = (char)46;
    private static char kJarSeparator = (char)47;
    private static String kClassExtension = ".class";

    public static byte[] getBytesForClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        return ByteClassUtil.getBytesForClass(cls, limit, feedback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesForClass(Class cls, int limit, IModuleFeedbackChannel feedback, boolean doSimpleClassNameSearch) throws IOException {
        block17: {
            byte[] byArray;
            InputStream is = null;
            String className = cls != null ? cls.getName() : "Unknown";
            try {
                byte[] classBytes;
                URL url;
                feedback.debug("getting bytes for class -" + className);
                ClassLoader classLoader = cls.getClassLoader();
                if (classLoader == null) {
                    byte[] byArray2 = ByteClassUtil.getBytesForClassUsingClass(cls, limit, feedback);
                    return byArray2;
                }
                String path = cls.getName().replace(kDotSeparator, kJarSeparator) + kClassExtension;
                feedback.debug("searching for path -" + path);
                is = classLoader.getResourceAsStream(path);
                if (is == null && doSimpleClassNameSearch && (url = classLoader.getResource(cls.getSimpleName() + kClassExtension)) != null) {
                    feedback.debug("Simple ClassName search succcessful. URL Path is: " + url.getPath());
                    is = url.openStream();
                }
                if (is == null) {
                    throw new IOException("input stream null");
                }
                byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            }
            catch (SecurityException e) {
                ByteClassUtil.logPotentialSecurityRestriction(feedback, e, "getBytesForClass vis Class", className);
                break block17;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesForClass(ClassLoader classLoader, String className, int limit, IModuleFeedbackChannel feedback) throws IOException {
        InputStream is = null;
        try {
            byte[] classBytes;
            feedback.debug("getting bytes for class -" + className);
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            String path = className.replace(kDotSeparator, kJarSeparator) + kClassExtension;
            feedback.debug("searching for path -" + path);
            is = classLoader.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byte[] byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            return byArray;
        }
        catch (SecurityException e) {
            ByteClassUtil.logPotentialSecurityRestriction(feedback, e, "getBytesForClass vis ClassLoader", className);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesForClassUsingClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        InputStream is = null;
        String className = cls != null ? cls.getName() : "Unknown";
        try {
            byte[] classBytes;
            feedback.debug("getting bytes for class -" + className);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            String path = cls.getName().replace(kDotSeparator, kJarSeparator) + kClassExtension;
            feedback.debug("searching for path -" + path);
            is = cl.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byte[] byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            return byArray;
        }
        catch (SecurityException e) {
            ByteClassUtil.logPotentialSecurityRestriction(feedback, e, "getBytesForClass vis Class 2", className);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesForClass(InputStream is, int classFileSizeLimit, IModuleFeedbackChannel feedback) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] byteArray = new byte[2048];
            int counter = 0;
            int i = is.read(byteArray);
            while (i > 0) {
                if (counter > classFileSizeLimit) {
                    feedback.debug("Cannot read Class File bigger than configured size - " + classFileSizeLimit / 512 + "MB");
                    byte[] byArray = null;
                    return byArray;
                }
                baos.write(byteArray, 0, i);
                ++counter;
                i = is.read(byteArray);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        byte[] retArray = baos.toByteArray();
        feedback.trace("returning byte array of length ->" + retArray.length);
        return retArray;
    }

    private static void logPotentialSecurityRestriction(IModuleFeedbackChannel feedback, Exception e, String func, String className) {
        feedback.error(func + ": Failed to get class bytes for : " + className);
        feedback.error("Probable cause: If -Djava.security.manager is being passed to JVM arguments please check Java Runtime \njre/lib/security/java.policy file which could have restricted read access to not found classes location.\nAdditionally, if a custom policy file is being passed to -Djava.security.manager also check that file as well.");
        ByteClassUtil.exceptionLogHelper(null, feedback, e);
    }

    private static void exceptionLogHelper(String message, IModuleFeedbackChannel feedback, Exception e) {
        if (message != null) {
            feedback.error(message);
        }
        if (e != null) {
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            feedback.error(stack.toString());
        }
    }
}

