/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument.attach.transformers;

import com.wily.introscope.api.instrument.JavaAgent;
import com.wily.introscope.api.instrument.attach.transformers.JBossModuleSystemPackagePropertyFix;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

public class JBossTransformer
implements ClassFileTransformer {
    public static boolean isJBoss() {
        if (System.getProperty("jboss.modules.system.pkgs") != null) {
            return true;
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        return jbossHome != null && new File(jbossHome + File.separator + "jboss-modules.jar").exists();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String targetClassName = "org/jboss/modules/Module";
        if (className.equals(targetClassName) && classBeingRedefined != null && JBossModuleSystemPackagePropertyFix.fixJBossModule(classBeingRedefined, null)) {
            JavaAgent.bootstrapRetransformLatch.countDown();
        }
        return null;
    }
}

