/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractInstrumentationInfo
implements Externalizable {
    public static final String kUndefinedLabel = "Undefined";
    private String groupName;
    private String labelName;
    private boolean isActive;
    private boolean isPermanent;
    private boolean isTemporary;
    private int fLineNumber = -1;

    protected AbstractInstrumentationInfo() {
    }

    protected AbstractInstrumentationInfo(int lineNumber, boolean isActive, boolean isPermanent, String groupName, String labelName) {
        this.fLineNumber = lineNumber;
        this.isActive = isActive;
        this.isPermanent = isPermanent;
        this.groupName = groupName;
        this.labelName = labelName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupName = (String)in.readObject();
        this.labelName = (String)in.readObject();
        this.isActive = in.readBoolean();
        this.isPermanent = in.readBoolean();
        this.isTemporary = in.readBoolean();
        this.fLineNumber = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.groupName);
        out.writeObject(this.labelName);
        out.writeBoolean(this.isActive);
        out.writeBoolean(this.isPermanent);
        out.writeBoolean(this.isTemporary);
        out.writeInt(this.fLineNumber);
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setPermanent(boolean isPermanent) {
        this.isPermanent = isPermanent;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public void setLineNumber(int i) {
        this.fLineNumber = i;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public boolean canBeRemoved() {
        return this.labelName != null && !this.labelName.equals(kUndefinedLabel);
    }
}

