/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.agent.ICompressedTimesliceData;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FastSerializedAgent2MetricDataSet
implements Externalizable,
ICompressedTimesliceData {
    private static final long serialVersionUID = 4730770199924624043L;
    private AgentMetricData[] fBindings;

    public FastSerializedAgent2MetricDataSet(AgentMetricData[] bindings) {
        this.fBindings = bindings;
    }

    public FastSerializedAgent2MetricDataSet() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fBindings = this.readData(in);
    }

    private AgentMetricData[] readData(ObjectInput in) throws IOException, ClassNotFoundException {
        AgentMetricData[] data = null;
        int length = in.readInt();
        if (length > -1) {
            data = new AgentMetricData[length];
            int iter = 0;
            while (iter < length) {
                data[iter] = this.readPartialData(in);
                ++iter;
            }
        }
        return data;
    }

    private AgentMetricData readPartialData(ObjectInput in) throws IOException, ClassNotFoundException {
        AgentMetric metric = (AgentMetric)in.readObject();
        int typeCookie = metric.getAttributeType();
        ATimeslicedValue value = null;
        value = TypeInquisitor.isInteger(typeCookie) ? new IntegerTimeslicedValue() : (TypeInquisitor.isLong(typeCookie) ? new LongTimeslicedValue() : new StringTimeslicedValue());
        value.readExternal(in);
        return new AgentMetricData(metric, Frequency.getFrequencyInMillis(in.readInt()), value);
    }

    private void writePartialData(ObjectOutput out, AgentMetricData data) throws IOException {
        out.writeObject(data.getAgentMetric());
        data.getTimeslicedValue().writeExternal(out);
        out.writeInt((int)data.getFrequency().getPeriodInMilliseconds());
    }

    private void writeData(ObjectOutput out, AgentMetricData[] data) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            int iter = 0;
            while (iter < data.length) {
                this.writePartialData(out, data[iter]);
                ++iter;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeData(out, this.fBindings);
    }

    @Override
    public AgentMetricData[] toArray() {
        return this.fBindings;
    }
}

