/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.stat.gatherer.AIntegerCombiningGatherer;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntegerMonotonicallyIncreasingCounterGatherer
extends AIntegerCombiningGatherer {
    private int fValue;
    private int fMinimum;

    public IntegerMonotonicallyIncreasingCounterGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(TypeInquisitor.isTimestamp(typeCookie));
    }

    @Override
    public int getIntValue() {
        return this.fValue;
    }

    @Override
    public int getIntMinimum() {
        return this.fMinimum;
    }

    @Override
    public int getIntMaximum() {
        return this.getIntValue();
    }

    protected void directSetIntValue(int value) {
        this.fValue = value;
    }

    @Override
    protected void directSetIntMinimum(int minimum) {
        this.fMinimum = minimum;
    }

    @Override
    protected void directSetIntMaximum(int maximum) {
        Assertion.wilyAssert(false);
    }

    public synchronized void setValue(int value) {
        this.setValueUnsync(value);
    }

    public synchronized void increment() {
        this.setValueUnsync(this.getIntValue() + 1);
    }

    public synchronized void add(int delta) {
        Assertion.wilyAssert(false);
        this.setValueUnsync(this.getIntValue() + delta);
    }

    @Override
    protected void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue typedAggregate) {
        if (typedAggregate.getDataPointCount() != 0L) {
            Assertion.wilyAssert(false);
            this.directSetIntValue(typedAggregate.getValue());
            this.syncAggregateBounds(typedAggregate);
            this.addToDataPointCount(typedAggregate.getDataPointCount());
        }
    }

    private void setValueUnsync(int value) {
        Assertion.wilyAssert(false);
        this.directSetIntValue(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
        this.newDataPointsReceived();
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
        this.directSetIntValue(0);
        this.directSetIntMinimum(0);
    }
}

