/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.timeslice;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.util.adt.StringPool;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public final class StringTimeslicedValue
extends ATimeslicedValue {
    public static final int kApproximateMemorySize = 64;
    private static final long serialVersionUID = 2342661181400697633L;
    private String fValue;
    public static final int kTruncationLength = 21845;

    public StringTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, boolean dataIsAbsent) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 0L, dataIsAbsent, "");
    }

    public StringTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, String value) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 1L, false, value);
    }

    public StringTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long dataPointCount, boolean dataIsAbsent, String value) {
        super(typeCookie, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fValue = StringTimeslicedValue.truncate(value);
    }

    private static String truncate(String s) {
        if (s.length() >= 21845) {
            s = s.substring(0, 21845);
        }
        return s;
    }

    public StringTimeslicedValue(DataInputStream stream, BlameStackSnapshot blameStack) throws IOException {
        this.readExternalData(stream, blameStack);
        Assertion.wilyAssert(false);
    }

    public StringTimeslicedValue() {
    }

    @Override
    public final String getValueAsString() {
        return this.getString();
    }

    public final String getString() {
        return this.fValue;
    }

    public static StringTimeslicedValue checkedCast(IMetricDataValue abstractValue) throws IncompatibleTypesException {
        try {
            return (StringTimeslicedValue)abstractValue;
        }
        catch (ClassCastException cce) {
            throw new IncompatibleTypesException("Failed to cast the object: " + abstractValue + " to an StringTimeslicedValue", cce);
        }
    }

    @Override
    public String toString() {
        return "StringTimeslicedValue: " + super.toString() + " val: " + this.fValue;
    }

    @Override
    public int hashCode() {
        int result = this.hashCodeDNA();
        if (this.getString() != null) {
            result ^= this.getString().hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StringTimeslicedValue)) {
            return false;
        }
        StringTimeslicedValue castTarget = (StringTimeslicedValue)o;
        boolean result = this.equalsDNA(castTarget);
        if (result) {
            String ourString = this.getString();
            String targetString = castTarget.getString();
            result = ourString == null || targetString == null ? ourString == targetString : ourString.equals(targetString);
        }
        return result;
    }

    @Override
    protected void writeExternalData(DataOutput out) throws IOException {
        super.writeExternalData(out);
        if (this.getDataPointCount() != 0L) {
            out.writeUTF(this.fValue);
        }
    }

    @Override
    protected void readExternalData(DataInput in, BlameStackSnapshot blameStack) throws IOException {
        super.readExternalData(in, blameStack);
        String result = "";
        if (this.getDataPointCount() != 0L) {
            result = in.readUTF();
        }
        this.fValue = StringPool.getPooled(result);
    }
}

